## CARATTERISTICHE PRINCIPALI

Le funzionalità chiave del componente Tabs Espandibili includono:

- La possibilità di personalizzare i titoli e il contenuto delle schede
- L'utilizzo di un sistema di espansione/compressione per gestire la visualizzazione del contenuto
- La compatibilità con diversi tipi di contenuto, inclusi testo, immagini e altri elementi multimediali

Gli aspetti tecnici rilevanti includono:

- L'utilizzo di HTML, CSS e JavaScript per la creazione e gestione del componente
- La possibilità di integrare il componente con altre librerie e framework di sviluppo web

Le caratteristiche di accessibilità includono:

- La conformità ai standard WCAG 2.1 per l'accessibilità web
- La possibilità di personalizzare la struttura e il contenuto del componente per soddisfare le esigenze degli utenti con disabilità

## VARIANTI

Le varianti disponibili per il componente Tabs Espandibili includono:

- **Story: Expandable Tabs**

* Descrizione: una scheda espandibile con un titolo personalizzabile e un contenuto gestibile
* Caso d'uso: utilizzare la scheda espandibile per visualizzare informazioni dettagliate su un argomento specifico

- **Story: Basic Expandable Tabs**

* Descrizione: una versione semplificata della scheda espandibile con un titolo e un contenuto predefiniti
* Caso d'uso: utilizzare la scheda espandibile di base per creare una navigazione semplice e intuitiva

## BEST PRACTICES

Le raccomandazioni d'uso per il componente Tabs Espandibili includono:

- Utilizzare titoli chiari e concisi per le schede
- Gestire il contenuto all'interno delle schede in modo da mantenere la leggibilità e l'accessibilità
- Utilizzare la funzionalità di espansione/compressione per gestire la visualizzazione del contenuto

Le linee guida implementative includono:

- Utilizzare HTML, CSS e JavaScript per creare e gestire il componente
- Integrare il componente con altre librerie e framework di sviluppo web per migliorare la funzionalità e l'accessibilità

Le pratiche da evitare includono:

- Utilizzare titoli troppo lunghi o complessi per le schede
- Non gestire il contenuto all'interno delle schede in modo da compromettere la leggibilità e l'accessibilità

## COMPONENTI CORRELATI

I componenti associati al componente Tabs Espandibili includono:

- **Accordion**: un componente che consente di visualizzare e gestire più sezioni di contenuto in modo espandibile
- **Collapse**: un componente che consente di comprimere o espandere il contenuto all'interno di una sezione

Le relazioni con altri elementi includono:

- La possibilità di integrare il componente con altre librerie e framework di sviluppo web per migliorare la funzionalità e l'accessibilità
- La conformità ai standard WCAG 2.1 per l'accessibilità web
-

## OVERVIEW

<div class="table-responsive">`import { ExpandableTabsComponent } from '@inail/intranet-webkit/tabs';`</div>

Il ExpandableTabsComponent è un componente che rappresenta un set di schede espandibili configurabili in Angular. Consente di definire dinamicamente un array di schede (tabs), con contenuti personalizzati associati a ciascuna scheda tramite l'uso di template, e supporta la gestione dello stato attivo della scheda corrente tramite la proprietà di input activeTab. Inoltre, emette un evento (tabChanged) ogni volta che l'utente cambia la scheda attiva, rendendolo altamente interattivo e adatto a scenari dinamici.

Il componente è altamente configurabile e supporta proprietà, eventi e opzioni, per gestire scenari complessi, migliorando l'esperienza utente e l'accessibilità

## API

<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
      <tr>
         <th style="width: 20%"><strong>Campo</strong></th>
         <th style="width: 80%"><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>id</code></td>
         <td> <code> @Input() id = composeUniqueId('tabs');</code><br /> Identificativo univoco per la Expandable Tabs. Può essere utilizzato per riferirsi al componente in modo specifico. </td>
      </tr>
      <tr>
         <td><code>tabs</code></td>
         <td>
            `@Input() tabs: ExpandableTab[] = [];` <br />
            Array di oggetti che rappresentano le schede che verranno visualizzate. <br />
            Tipo di oggetto <a href = "?path=/docs/resources-models-expandabletab--docs">ExpandableTab</a>
         </td>
      </tr>
      <tr>
         <td><code>activeTab</code></td>
         <td>
            `@Input() activeTab!: ExpandableTab | null;` <br />
            Rappresenta il tab attualmente attivo (espanso).
            <br />
            Tipo di oggetto <a href = "?path=/docs/resources-models-expandabletab--docs">ExpandableTab</a>
         </td>
      </tr>
   </tbody>
</table>
</div>

<br/>

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
	<tr>
	  <th style="width: 20%"><strong>Campo</strong></th>
	  <th style="width: 80%"><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
	<tr>
	  <td><code>tabChanged</code></td>
	  <td>
		`@Output() tabChanged = new EventEmitter<ExpandableTabsEvent>();` <br />
		Event emitter che gestisce l'evento onChangeTab($event).
	  </td>
	</tr>
  </tbody>
</table>
</div>
