$(document).ready(function () {

/*     
//Alessio1
var $input = $("input[data-input-type='multiselect']");
var $dropdown = $("#dropdownMenu");
var $options = $(".option-item");
var currentIndex = -1;

// Apertura del menu con Enter
$input.keydown(function(e) {
    if (e.key === "Enter") {
        e.preventDefault(); // Previeni il comportamento predefinito
        $dropdown.toggle(); // Toggle visibilità del dropdown
        highlightOption(); // Evidenzia la prima opzione
    } else if (e.key === "ArrowDown") {
        e.preventDefault();
        currentIndex = (currentIndex + 1) % $options.length;
        highlightOption();
    } else if (e.key === "ArrowUp") {
        e.preventDefault();
        currentIndex = (currentIndex - 1 + $options.length) % $options.length;
        highlightOption();
    } else if (e.key === "Enter" || e.key === " ") {
        e.preventDefault();
        toggleSelection();
    } else if (e.key === "Escape") {
        $dropdown.hide();
    }
});

// Aggiungere la logica per aprire il menu al click sull'input
$input.click(function(e) {
    e.preventDefault(); // Previene il comportamento predefinito
    $dropdown.toggle(); // Toggle visibilità del dropdown
    highlightOption(); // Evidenzia la prima opzione
});

// Gestire la chiusura con `Esc` quando il focus è all'interno del menu
$dropdown.keydown(function(e) {
    if (e.key === "Escape") {
        $dropdown.hide(); // Chiudi il menu se `Esc` viene premuto
    }
});

// Evidenzia l'opzione attuale
function highlightOption() {
    $options.removeClass("active");
    if (currentIndex >= 0) {
        $options.eq(currentIndex).addClass("active").focus();
    }
}

// Seleziona/deseleziona la checkbox attuale
function toggleSelection() {
    var $checkbox = $options.eq(currentIndex).find("input[type='checkbox']");
    $checkbox.prop("checked", !$checkbox.prop("checked"));
    updateSelectedValues(); // Aggiorna i valori nell'input
}

// Aggiorna l'input con le opzioni selezionate
function updateSelectedValues() {
    // Raccogli tutti i valori delle checkbox selezionate
    var selectedValues = $(".option-checkbox:checked").map(function() {
        return $(this).val();
    }).get().join(", ");
    
    // Inserisci i valori nel campo di input
    $input.val(selectedValues);
}

// Chiudi il dropdown quando si clicca fuori
$(document).click(function(event) {
    if (!$(event.target).closest(".dropdown").length) {
        $dropdown.hide();
    }
});

// Aggiungi un evento per la selezione/deselezione delle checkbox
$(".option-checkbox").change(function() {
    updateSelectedValues(); // Aggiorna il valore dell'input quando una checkbox cambia
}); */
    
var $input = $("input[data-input-type='multiselect']");
var $dropdown = $("#dropdownMenu");
var $checkboxes = $(".option-checkbox");
var currentIndex = -1;
var isOpening = false; // Flag per evitare selezione immediata

// Apri/chiudi il menu con Click o Enter
$input.on("click keydown", function (e) {
    if (e.type === "click" || e.key === "Enter") {
        e.preventDefault();
        if ($dropdown.is(":visible")) {
            $dropdown.hide();
        } else {
            $dropdown.show();
            currentIndex = 0;
            highlightOption();
            isOpening = true; // Imposta il flag per evitare selezione
            /* setTimeout(() => isOpening = false, 200);  //Reset dopo breve delay */
        }
    }
});

// Navigazione con le frecce
$(document).on("keydown", function (e) {
    if (!$dropdown.is(":visible")) return;

    if (e.key === "ArrowDown") {
        e.preventDefault();
        moveSelection(1);
    } else if (e.key === "ArrowUp") {
        e.preventDefault();
        moveSelection(-1);
    } else if ((e.key === "Enter" || e.key === " ") && !isOpening) {
        e.preventDefault();
        toggleSelection();
    } else if (e.key === "Escape") {
        $dropdown.hide();
    }
});

// Sposta la selezione in alto o in basso
function moveSelection(direction) {
    currentIndex = (currentIndex + direction + $checkboxes.length) % $checkboxes.length;
    highlightOption();
}

// Evidenzia e mette il focus sulla checkbox attuale
function highlightOption() {
    $checkboxes.eq(currentIndex).focus();
}

// Seleziona/deseleziona la checkbox attuale
function toggleSelection() {
    var $checkbox = $checkboxes.eq(currentIndex);
    $checkbox.prop("checked", !$checkbox.prop("checked")).trigger("change");
}

// Aggiorna l'input con le opzioni selezionate
function updateSelectedValues() {
    var selectedValues = $(".option-checkbox:checked").map(function () {
        return $(this).val();
    }).get().join(", ");
    $input.val(selectedValues);
}

// Chiudi il dropdown cliccando fuori
$(document).click(function (event) {
    if (!$(event.target).closest(".dropdown").length) {
        $dropdown.hide();
    }
});

// Aggiorna il valore dell'input quando cambia una checkbox
$(".option-checkbox").change(updateSelectedValues);


    
/*     
// Funzione per filtrare i risultati in base alla ricerca
$("#searchInput").on("keyup", function() {
    var searchValue = $(this).val().toLowerCase();
    
    $options.each(function() {
        var optionText = $(this).text().toLowerCase();
        var $checkbox = $(this).find("input[type='checkbox']");
        var isChecked = $checkbox.prop("checked");

        // Mostra sempre le opzioni selezionate, altrimenti applica il filtro di ricerca
        if (isChecked || optionText.includes(searchValue)) {
            $(this).show();
        } else {
            $(this).hide();
        }
    });
}); */


});
