# ErrorLabel

Documentazione dettagliata della custom class **ErrorLabel**, usata nei componenti di Internet Webkit v17. 
**ErrorLabel** viene utilizzata per creare elementi che visualizzano un messaggio di errore nel template.

## Implementazione
<div class="table-responsive">`import { ErrorLabel } from '@inail/internet-webkit';`</div>
<br />

***Struttura:***
`constructor(checkFn: (control?: FormControl) => boolean, 
  message: string,
  messageParams?: any,
  color?: ErrorLabelColor)`

***Esempio d'uso:***
<br />
<div class="table-responsive">`errorLabel = new ErrorLabel((control) => (control ? control.hasError('required') : false), 'ERROR.REQUIRED', {}, ErrorLabelColor.ERROR)`</div>

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>checkFn</code></td>
      <td>
        Funzione che verifica tramite il FormControl, se c'e un errore specifico presente.
      </td>
    </tr>
    <tr>
      <td><code>message</code></td>
      <td>
        Campo di tipo string che imposta il testo che verrà visualizzato nel messaggio errore.
      </td>
    </tr>
    <tr>
      <td><code>messageParams</code></td>
      <td>
        Campo di tipo placeholder per messaggi i18n.
      </td>
    </tr>
    <tr>
      <td><code>color</code></td>
      <td>
        Campo di tipo <code>ErrorLabelColor</code> che imposta il colore dell'error label.
        I valori dell' enum sono i seguenti:
        <ul>
          <li>
            ERROR = "msg-error"
          </li>
          <li>
            WARNING = "msg-warning",
          </li>
          <li>
            GREEN = "msg-ok"
          </li>
        </ul>
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-form-form-controls-checkbox--checkbox">Form Controls</a>