## CARATTERISTICHE PRINCIPALI

Le caratteristiche principali del componente "Pulsante di Azione" sono:

* **Funzionalità chiave**: il pulsante può essere configurato per richiamare azioni specifiche, come ad esempio l'invio di un form o l'apertura di una finestra modale.
* **Aspetti tecnici rilevanti**: il componente utilizza HTML, CSS e JavaScript per la sua implementazione. È compatibile con diversi browser e dispositivi mobili.
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile agli utenti con disabilità, seguendo le linee guida WCAG 2.1.

## VARIANTI

Le varianti disponibili per il componente "Pulsante di Azione" sono:

* **Variante principale**: pulsante standard con testo e icona.
	+ Casi d'uso specifici: utilizzato come pulsante di invio per un form, o come pulsante di azione per aprire una finestra modale.
	+ Breve descrizione: pulsante standard con testo e icona che richiama un'azione specifica.
* **Variante secondaria**: pulsante senza icona.
	+ Casi d'uso specifici: utilizzato come pulsante di conferma per un messaggio, o come pulsante di navigazione per una pagina web.
	+ Breve descrizione: pulsante senza icona che richiama un'azione specifica.
* **Variante terziaria**: pulsante con immagine di sfondo.
	+ Casi d'uso specifici: utilizzato come pulsante di promozione per un prodotto, o come pulsante di chiamata all'azione per una campagna pubblicitaria.
	+ Breve descrizione: pulsante con immagine di sfondo che richiama un'azione specifica.

## BEST PRACTICES

Le raccomandazioni d'uso per il componente "Pulsante di Azione" sono:

* Utilizzare il componente in modo coerente all'interno della pagina web.
* Personalizzare l'aspetto e le dimensioni del pulsante in base alle esigenze specifiche della pagina.
* Assicurarsi che il pulsante sia accessibile agli utenti con disabilità.

Le linee guida implementative sono:

* Utilizzare HTML, CSS e JavaScript per la implementazione del componente.
* Seguire le linee guida WCAG 2.1 per l'accessibilità.

Le pratiche da evitare sono:

* Non utilizzare il componente in modo eccessivo o inappropriato.
* Non modificare l'aspetto o le dimensioni del pulsante in modo arbitrario.

## COMPONENTI CORRELATI

I componenti associati al "Pulsante di Azione" sono:

* **Form**: il pulsante può essere utilizzato per inviare un form.
* **Finestra modale**: il pulsante può essere utilizzato per aprire una finestra modale.

Le relazioni con altri elementi sono:

* Il pulsante può essere utilizzato all'interno di una pagina web per richiamare azioni specifiche.
* Il pulsante può essere personalizzato in base alle esigenze specifiche della pagina.