$(document).ready(function () {
    /*
    // Funzione di inizializzazione
    function initializeMultiSelect() {
        const $dropdown = $('#multiSelectDropdown');
        const $searchInput = $('#searchInput');
        const $select = $('#select')
        const $multiSelectContainer = $('#multiSelectContainer');

        // Mostra la dropdown quando l'utente clicca sull'input di ricerca
        $select.on('click', function() {
            $dropdown.show();
        });

        // Nascondi la dropdown quando l'utente clicca fuori dalla dropdown
        $(document).on('click', function(event) {
            if (!$(event.target).closest('.multi-select-container').length) {
              // alert('entro document')
              $dropdown.hide();
            }
        });

        // Gestisci il click dentro la dropdown per non farla chiudere
        $multiSelectContainer.on('click', function(event) {
            event.stopPropagation(); // Impedisce che il click si propaghi e nasconda la dropdown
        });

        // Seleziona tutti i div con la classe "stop-prop"
        $('div.option').on('click', function (event) {
            const selectedOptions = [];
            $dropdown.find('input[type="checkbox"]:checked').each(function() {
                selectedOptions.push($(this).val());
            });
            console.log('Selected options:', selectedOptions);
        });

        // Filtra le opzioni mentre l'utente scrive nella barra di ricerca
        $searchInput.on('input', function() {
            const searchTerm = $searchInput.val().toLowerCase();
            $dropdown.find('.option').each(function() {
                const optionText = $(this).find('label').text().toLowerCase();
                $(this).toggle(optionText.indexOf(searchTerm) > -1);
            });
        });

        // Gestisci la selezione delle checkbox
        $dropdown.on('change', 'input[type="checkbox"]', function() {
            const selectedOptions = [];
            $dropdown.find('input[type="checkbox"]:checked').each(function() {
                selectedOptions.push($(this).val());
            });
            console.log('Selected options:', selectedOptions);
        });
    }

    // Inizializza la multi-select
    initializeMultiSelect();
    */
    
/*     

/* 
//Alessio2
    var $select = $("#multiSelect");
    var $customOptions = $("#customOptions");
    var $input = $("#multiSelectInput");

    // Popola la lista personalizzata con le checkbox
    $select.find("option").each(function() {
        var value = $(this).val();
        var text = $(this).text();
        $customOptions.append(
            '<div class="checkbox"><label><input type="checkbox" class="option-checkbox" value="' + value + '"> ' + text + '</label></div>'
        );
    });

    // Apri il menu quando si clicca sull'input
    $input.click(function() {
        $(".dropdown-menu").toggle();
    });

    // Gestisci la selezione delle checkbox
    $(".option-checkbox").change(function() {
        var selected = [];
        $(".option-checkbox:checked").each(function() {
            selected.push($(this).val());
        });

        // Aggiorna il valore dell'input
        $input.val(selected.join(", "));

        // Seleziona/deseleziona anche nel <select>
        $select.find("option").each(function() {
            $(this).prop("selected", selected.includes($(this).val()));
        });
    });

    // Funzione di ricerca per filtrare le opzioni
    $("#searchInput").on("keyup", function() {
        var filter = $(this).val().toLowerCase();
        $(".checkbox").each(function() {
            var text = $(this).text().toLowerCase();
            $(this).toggle(text.indexOf(filter) > -1);
        });
    });

    // Chiudi il menu quando si clicca fuori
    $(document).click(function(event) {
        if (!$(event.target).closest(".custom-dropdown").length) {
            $(".dropdown-menu").hide();
        }
    }); */


//Alessio1
var $input = $("input[data-input-type='multiselect']");
var $dropdown = $("#dropdownMenu");
var $options = $(".option-item");
var currentIndex = -1;

// Apertura del menu con Enter
$input.keydown(function(e) {
    if (e.key === "Enter") {
        e.preventDefault(); // Previeni il comportamento predefinito
        $dropdown.toggle(); // Toggle visibilità del dropdown
        highlightOption(); // Evidenzia la prima opzione
    } else if (e.key === "ArrowDown") {
        e.preventDefault();
        currentIndex = (currentIndex + 1) % $options.length;
        highlightOption();
    } else if (e.key === "ArrowUp") {
        e.preventDefault();
        currentIndex = (currentIndex - 1 + $options.length) % $options.length;
        highlightOption();
    } else if (e.key === "Enter" || e.key === " ") {
        e.preventDefault();
        toggleSelection();
    } else if (e.key === "Escape") {
        $dropdown.hide();
    }
});

// Aggiungere la logica per aprire il menu al click sull'input
$input.click(function(e) {
    e.preventDefault(); // Previene il comportamento predefinito
    $dropdown.toggle(); // Toggle visibilità del dropdown
    highlightOption(); // Evidenzia la prima opzione
});

// Gestire la chiusura con `Esc` quando il focus è all'interno del menu
$dropdown.keydown(function(e) {
    if (e.key === "Escape") {
        $dropdown.hide(); // Chiudi il menu se `Esc` viene premuto
    }
});

// Evidenzia l'opzione attuale
function highlightOption() {
    $options.removeClass("active");
    if (currentIndex >= 0) {
        $options.eq(currentIndex).addClass("active").focus();
    }
}

// Seleziona/deseleziona la checkbox attuale
function toggleSelection() {
    var $checkbox = $options.eq(currentIndex).find("input[type='checkbox']");
    $checkbox.prop("checked", !$checkbox.prop("checked"));
    updateSelectedValues(); // Aggiorna i valori nell'input
}

// Aggiorna l'input con le opzioni selezionate
function updateSelectedValues() {
    // Raccogli tutti i valori delle checkbox selezionate
    var selectedValues = $(".option-checkbox:checked").map(function() {
        return $(this).val();
    }).get().join(", ");
    
    // Inserisci i valori nel campo di input
    $input.val(selectedValues);
}

// Chiudi il dropdown quando si clicca fuori
$(document).click(function(event) {
    if (!$(event.target).closest(".dropdown").length) {
        $dropdown.hide();
    }
});

// Aggiungi un evento per la selezione/deselezione delle checkbox
$(".option-checkbox").change(function() {
    updateSelectedValues(); // Aggiorna il valore dell'input quando una checkbox cambia
});

// Funzione per filtrare i risultati in base alla ricerca
/* $("#searchInput").on("keyup", function() {
    var searchValue = $(this).val().toLowerCase();
    
    $options.each(function() {
        var optionText = $(this).text().toLowerCase();
        if (optionText.includes(searchValue)) {
            $(this).show();
        } else {
            $(this).hide();
        }
    });
}); */
    
    // Funzione per filtrare i risultati in base alla ricerca
$("#searchInput").on("keyup", function() {
    var searchValue = $(this).val().toLowerCase();
    
    $options.each(function() {
        var optionText = $(this).text().toLowerCase();
        var $checkbox = $(this).find("input[type='checkbox']");
        var isChecked = $checkbox.prop("checked");

        // Mostra sempre le opzioni selezionate, altrimenti applica il filtro di ricerca
        if (isChecked || optionText.includes(searchValue)) {
            $(this).show();
        } else {
            $(this).hide();
        }
    });
});


});
