# RadioOption

Documentazione dettagliata dell'oggetto custom **RadioOption**, usato nei componenti di Intranet Webkit v17. 
**RadioOption** è progettata per rappresentare un'opzione utilizzabile, ad esempio, all'interno di un gruppo di opzioni radio (radio buttons).

## Implementazione
<div class="table-responsive">`import {RadioOption} from '@inail/intranet-webkit';`</div>
<br />


***Struttura:***
`constructor(
  label: string,
  payload: any, 
  tooltip?: TooltipModel
)`

***Esempio d'uso:***
<br />
`  options: RadioOption.fromIdValueArray([
      { id: 1, value: 'INPUT.MS_OPTION_1' },
      { id: 2, value: 'INPUT.MS_OPTION_2' },
      { id: 3, value: 'INPUT.MS_OPTION_3' },
      { id: 4, value: 'INPUT.MS_OPTION_4' },
  ])`


## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>_label</code></td>
      <td>
        Memorizza il testo o l'etichetta associata all'opzione.
      </td>
    </tr>
    <tr>
      <td><code>_payload</code></td>
      <td>
       Contiene il valore o i dati associati all'opzione.
      </td>
    </tr>
    <tr>
      <td><code>_tooltip</code></td>
      <td>
        È un oggetto opzionale di tipo <a href="?path=/docs/resources-models-tooltipmodel--docs">TooltipModel</a>, che definisce un tooltip associato all'opzione.
      </td>
    </tr>
    <tr>
      <td><code>fromIdValueArray</code></td>
      <td>
        Accetta un array di oggetti con campi id (numero) e value (stringa). <br>
        Restituisce un array di oggetti RadioOption, costruiti utilizzando i valori di id e value.
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-form-form-controls-radio--radio">Radio</a>
