## CARATTERISTICHE PRINCIPALI
- **Funzionalità chiave**: il componente consente la selezione di una o più opzioni da un elenco, con la possibilità di visualizzare le descrizioni delle opzioni stesse.
- **Aspetti tecnici rilevanti**: il componente utilizza una struttura di tabella per presentare le opzioni e le relative descrizioni. Gli elementi della tabella sono gestiti tramite un sistema di controlli che permettono la selezione delle opzioni.
- **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile agli utenti con disabilità, grazie all'utilizzo di attributi ARIA e all'implementazione di funzionalità di navigazione tramite tastiera.

## VARIANTI
- **Elenco e descrizione delle varianti disponibili**:
  - CONIUGE: variante che consente la selezione di un coniuge come beneficiario.
  - FIGLIO/A: variante che consente la selezione di un figlio/a come beneficiario.
  - ALTRO: variante che consente la selezione di un altro tipo di beneficiario.
- **Casi d'uso specifici per ogni variante**:
  - CONIUGE: utile quando si vuole designare il coniuge come beneficiario di una polizza assicurativa o di un piano pensionistico.
  - FIGLIO/A: utile quando si vuole designare un figlio/a come beneficiario di una polizza assicurativa o di un piano pensionistico.
  - ALTRO: utile quando si vuole designare un altro tipo di beneficiario, ad esempio un familiare o un amico.

## BEST PRACTICES
- **Raccomandazioni d'uso**: utilizzare il componente Radio Table Form quando è necessario presentare un elenco di opzioni e descrizioni in modo chiaro e efficiente.
- **Linee guida implementative**: assicurarsi di implementare correttamente gli attributi ARIA e le funzionalità di navigazione tramite tastiera per garantire l'accessibilità del componente.
- **Pratiche da evitare**: non utilizzare il componente Radio Table Form quando è necessario presentare un elenco di opzioni molto lungo, poiché ciò potrebbe rendere difficile la navigazione per gli utenti.

## COMPONENTI CORRELATI
- **Componenti associati**: altri componenti di interfaccia utente che possono essere utilizzati in combinazione con il Radio Table Form, ad esempio bottoni o link.
- **Relazioni con altri elementi**: il componente Radio Table Form può essere utilizzato all'interno di un modulo o di una sezione di un sito web per fornire un modo efficiente e chiaro per gli utenti di prendere decisioni tra diverse opzioni.

## OVERVIEW
<div class="table-responsive">`import { RadioTableFormComponent } from '@inail/intranet-webkit/form-controls';`</div>

Il componente `RadioTableFormComponent` viene utilizzato per creare una tabella con opzioni radio button, consentendo agli utenti di selezionare un'opzione per ogni riga. Supporta la configurazione dinamica della struttura e delle dimensioni della tabella, offrendo maggiore flessibilità nella personalizzazione. 
## API
<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>tableSize</code></td>
         <td>
            `@Input tableSize: string | BootstrapSize;` <br />
            Specifica le dimensioni della tabella utilizzando valori Bootstrap o stringhe predefinite. 
            Se non specificato, il valore predefinito è `'12|12|12|12'`.         </td>
      </tr>
       <tr>
         <td><code>description</code></td>
         <td>
            `@Input() description!: string;` <br />
            Descrizione obbligatoria che fornisce informazioni aggiuntive sull'uso della tabella.
         </td>
      </tr>
       <tr>
         <td><code>tableFormStructure</code></td>
         <td>
            `@Input() tableFormStructure: RadioTableFormStructure;` <br />
            Struttura che definisce le intestazioni e i campi del modulo della tabella.
         </td>
      </tr>
   </tbody>
</table>
</div>