## CARATTERISTICHE PRINCIPALI

Le caratteristiche chiave del componente Sticky sono:

* La capacità di diventare sticky quando l'utente fa scroll
* La possibilità di personalizzare il comportamento del componente attraverso proprietà specifiche

Gli aspetti tecnici rilevanti del componente Sticky sono:

* L'utilizzo di CSS per gestire la posizione e lo stile del componente
* La possibilità di utilizzare JavaScript per aggiungere funzionalità dinamiche al componente

Le caratteristiche di accessibilità del componente Sticky sono:

* La possibilità di utilizzare attributi ARIA per migliorare l'accessibilità del componente
* La conformità con gli standard WCAG 2.1 per garantire l'accessibilità del componente

## VARIANTI

Il componente Sticky dispone delle seguenti varianti:

* **Sticky Componente**: la variante di base del componente, che diventa sticky quando l'utente fa scroll
* **N.D.**: non sono disponibili altre varianti

Casi d'uso specifici per ogni variante:

* **Sticky Componente**: utilizzare il componente Sticky per tenere visibile e accessibile un elemento importante della pagina anche quando la pagina viene scollata

Breve descrizione per ogni variante:

* **Sticky Componente**: componente web che diventa sticky quando l'utente fa scroll

## BEST PRACTICES

Raccomandazioni d'uso del componente Sticky:

* Utilizzare il componente Sticky solo quando è necessario tenere visibile e accessibile un elemento importante della pagina
* Personalizzare il comportamento del componente attraverso proprietà specifiche per adattarlo alle esigenze della pagina

Linee guida implementative:

* Utilizzare CSS per gestire la posizione e lo stile del componente
* Utilizzare JavaScript per aggiungere funzionalità dinamiche al componente

Pratiche da evitare:

* Non utilizzare il componente Sticky in modo eccessivo, poiché può creare problemi di accessibilità e usabilità

## COMPONENTI CORRELATI

I componenti associati al componente Sticky includono:

* **Componente di navigazione**: il componente Sticky può essere utilizzato in combinazione con un componente di navigazione per fornire una migliore esperienza utente
* **Componente di contenuto**: il componente Sticky può essere utilizzato per visualizzare contenuti importanti, come ad esempio messaggi di errore o avvisi.

## OVERVIEW
<div class="table-responsive">`import { StickyComponent } from '@inail/intranet-webkit/elements';`</div>

Componente sticky che rimane visibile in cima alla pagina anche quando si effettua lo scroll.

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
	<tr>
	  <th style="width: 20%"><strong>Campo</strong></th>
	  <th style="width: 80%"><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
	<tr>
	  <td><code>title</code></td>
	  <td>
		  `@Input() title!: string;` <br />
		  Campo di tipo `string` che imposta il titolo del componente Sticky.
	  </td>
	</tr>
	<tr>
	  <td><code>subtitle</code></td>
	  <td>
		  `@Input() subtitle!: string;` <br />
		  Sottotitolo opzionale per il componente Sticky.
	  </td>
	</tr>
	<tr>
	  <td><code>tags</code></td>
	  <td>
		  `@Input() tags!: Tag[];` <br />
		  Array di oggetti <a href="?path=/docs/resources-models-tag--docs">Tag</a> che vengono visualizzati dal componente.
	  </td>
	</tr>
	<tr>
	  <td><code>actions</code></td>
	  <td>
		`@Input() actions!: ActionItem[];` <br />
		Array di oggetti <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a> che rappresentano le azioni da eseguire nel componente.
	  </td>
	</tr>
	<tr>
	  <td><code>closable</code></td>
	  <td>
		`@Input() closable: boolean = true;` <br />
		Booleano che determina se il componente può essere chiuso dall'utente. Il valore predefinito è true.
	  </td>
	</tr>
	<tr>
	  <td><code>reopenable</code></td>
	  <td>
		`@Input() reopenable: boolean = false;` <br />
		Booleano che determina se il componente può essere riaperto quando l'utente torna in cima alla pagina. Il valore predefinito è false.
	  </td>
	</tr>
	<tr>
	  <td><code>hideTitle</code></td>
	  <td>
		`@Input() hideTitle: boolean = false;` <br />
		Booleano che determina se il titolo del componente deve essere nascosto. Il valore predefinito è false.
	  </td>
	</tr>
  </tbody>
</table>
</div>