## CARATTERISTICHE PRINCIPALI
Le caratteristiche chiave del componente Timepicker sono:

* **Inserimento guidato dell’orario**: l’utente può digitare l’orario o selezionarlo da una lista predefinita
* **Validazione del formato**: supporta il formato 24h con limiti configurati (min, max, intervallo)
* **Gestione degli stati**: supporto nativo per stato disabilitato, errore e informativo
* **Accessibilità**: progettato per l’uso tramite tastiera e screen reader

Gli aspetti tecnici rilevanti del componente Timepicker includono:

* Utilizzo di **HTML semantico** e **CSS** per struttura e stile
* Configurazione tramite **data-attributes** (`data-time-min`, `data-time-max`, `data-time-interval`)
* Supporto alla localizzazione (`data-locale="it-IT"`)

## BEST PRACTICES
Le raccomandazioni per l’uso del componente Timepicker includono:

* Utilizzare il componente esclusivamente per l’inserimento di valori orari
* Mantenere coerenti i valori di **min**, **max** e **intervallo** in tutta l’applicazione
* Mostrare i messaggi di errore solo quando necessario
* Usare il tooltip informativo solo se l’etichetta non è autoesplicativa

Le linee guida implementative includono:

* Non rimuovere o modificare gli attributi `aria-*`
* Non eliminare gli elementi con classe `sr-only`
* Non alterare la struttura del DOM: il comportamento del timepicker dipende dai `data-*`

## COMPONENTI CORRELATI
Il componente Timepicker è associato ai seguenti componenti:

* **Input Text**: condivide struttura, classi CSS e gestione degli stati
* **Tooltip**: utilizzato nella variante informativa
* **Form Field**: contesto naturale di utilizzo del timepicker

Nota: le sezioni senza informazioni sono marcate con "N.D.".


## ACCESSIBILITA'
Il componente Timepicker è progettato per essere completamente accessibile.

* La lista delle opzioni è annunciata tramite un elemento con `aria-live`
* L’input è associato a testi di supporto tramite `aria-describedby`
* Sono presenti elementi `<span>` con classe `sr-only` che:
  * Forniscono istruzioni sull’uso della tastiera
  * Rendono comprensibile il comportamento del campo anche fuori dal contesto visivo

In particolare:
- L’apertura della lista avviene tramite **Invio**
- La navigazione tra le opzioni avviene tramite **frecce direzionali**
- Gli stati di errore sono comunicati sia visivamente che agli screen reader