# RadioTableFormStructure

Documentazione dettagliata dell'oggetto custom **RadioTableFormStructure**, usato nei componenti di Internet Webkit v17. 
**RadioTableFormStructure** è una classe che rappresenta l'intero form come una combinazione strutturata di un’intestazione e righe.

## Implementazione
<div class="table-responsive">`import { RadioTableFormStructure } from '@inail/internet-webkit/form-controls';`</div>
<br />

***Struttura:***
`constructor(
  header: HeaderRTF,
  form: FormRowRTF[]
)
`


***Esempio d'uso:***
<br />
` tableFormStructure: new RadioTableFormStructure(
      new HeaderRTF('INPUT.FULL_NAME', [
        new OptionRTF('CONIUGE', 'coniuge'),
        new OptionRTF('FIGLIO/A', 'figlio/a'),
        new OptionRTF('ALTRO', 'altro'),
      ]),
      [
        new FormRowRTF(
          'Familiare 1',
          new FormControl('Simple description for Familiare 1')
        ),
        new FormRowRTF(
          'Familiare 2',
          new FormControl('Simple description for Familiare 2')
        ),
        new FormRowRTF(
          'Familiare 3',
          new FormControl('Simple description for Familiare 3')
        ),
      ]
  )
`


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>header</code></td>
      <td>
        Campo di tipo <code>HeaderRTF</code> che rappresenta l’intestazione della tabella.
        <ul>
          <li>
            firstLabel: L’etichetta principale per l’intestazione.
          </li>
          <li>
            options: Un elenco di opzioni o configurazioni associate all’intestazione.
          </li>
          <li>
            labelsSize: Un array che definisce le dimensioni delle etichette nell’intestazione.
          </li>
        </ul>
        <code>constructor(firstLabel: string, options: OptionRTF[], labelsSize?: string[] | BootstrapSize[])</code>
      </td>
    </tr>
    <tr>
      <td><code>form</code></td>
      <td>
        Campo di tipo <code>FormRowRTF</code> che rappresenta le righe del form.
        <ul>
          <li>
            label: L’etichetta della riga.
          </li>
          <li>
            control: Rappresenta il controllo per la gestione dei dati in questa riga.
          </li>
          <li>
            template: Un riferimento a un template personalizzato per visualizzare contenuti dinamici nella riga.
          </li>
        </ul>
        <code>constructor(label: string, control: AbstractControl, template?: TemplateRef<any> | undefined);</code>
      </td>
    </tr>
  </tbody>
</table>
</div>


## Casi d'utilizzo
<br />
<a href="?path=/story/components-form-form-sections-radio-table-form--radio-table-form">Radio Table Form</a>
<br/>
