## CARATTERISTICHE PRINCIPALI

Il componente Radio Button presenta le seguenti caratteristiche chiave:

* Funzionalità di selezione: il componente consente all'utente di selezionare una sola opzione tra più alternative
* Aspetti tecnici rilevanti:
 + Il componente utilizza un array di oggetti per rappresentare le opzioni disponibili
 + Ogni oggetto dell'array contiene le proprietà "id", "label" e "value"
* Caratteristiche di accessibilità: il componente è progettato per essere accessibile anche agli utenti con disabilità, grazie alla possibilità di utilizzare la tastiera per navigare tra le opzioni

## VARIANTI
Il componente Radio Button presenta le seguenti varianti:

* **Variante 1**: Testo singolo
 + Descrizione: il componente visualizza un solo pulsante radio con un testo associato
 + Caso d'uso: utilizzato quando è necessario fornire all'utente una sola opzione di scelta
 + Breve descrizione: il componente visualizza un solo pulsante radio con un testo associato, consentendo all'utente di selezionare l'unica opzione disponibile
* **Variante 2**: Testo multiplo
 + Descrizione: il componente visualizza più pulsanti radio con testi associati
 + Caso d'uso: utilizzato quando è necessario fornire all'utente più opzioni di scelta
 + Breve descrizione: il componente visualizza più pulsanti radio con testi associati, consentendo all'utente di selezionare una delle opzioni disponibili

## BEST PRACTICES
Per utilizzare al meglio il componente Radio Button, è consigliabile seguire le seguenti linee guida:

* Utilizzare il componente quando è necessario fornire all'utente una sola opzione di scelta
* Evitare di utilizzare il componente quando sono disponibili più di 5 opzioni di scelta
* Utilizzare la tastiera per navigare tra le opzioni, al fine di migliorare l'accessibilità

## COMPONENTI CORRELATI
Il componente Radio Button è correlato ai seguenti componenti:

* Checkbox: il componente Checkbox consente all'utente di selezionare più opzioni tra un insieme di alternative
* Select: il componente Select consente all'utente di selezionare una sola opzione da un elenco di alternative

## OVERVIEW
<div class="table-responsive">`import { RadioComponent } from '@inail/internet-webkit/form-controls';`</div>

Il componente Radio è progettato per offrire una soluzione intuitiva e accessibile per selezionare un'unica opzione tra un gruppo predefinito. Ideale per situazioni in cui le scelte sono reciprocamente esclusive.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
   <tr>
	  <td><code>line</code></td>
	  <td>
		`@Input() line = false;` <br />
		Controlla il layout del componente radio, visualizzandolo come un elemento a block-level quando è impostato su false o inline con altri elementi quando è impostato su true.
	  </td>
	</tr>
	<tr>
	  <td><code>field-for-id</code></td>
	  <td>
		`@Input('field-for-id') fieldForId: string | undefined;` <br />
		Specificare il nome del campo per estrarre il valore per il form control.
	  </td>
	</tr>
	<tr>
	  <td><code>field-for-option</code></td>
	  <td>
		`@Input('field-for-option') fieldForOptionElement = 'descrizione';` <br />
		Il nome del campo utilizzato per l'etichetta di ciascuna opzione del radio.
	  </td>
	</tr>
    <tr>
	  <td><code>options</code></td>
	  <td>
		`@Input() options: RadioOption[]` <br />
		 Gestisce il set delle opzioni disponibili per il componente Radio. 
	  </td>
	</tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class RadioComponent extends BaseInputComponent` <br />
        Fare riferimento a <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent.</a>
      </td>
    </tr>
	<tr>
	  <td><code>size</code></td>
	  <td>
		`@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
		La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
	  </td>
	</tr>
  </tbody>
</table>
</div>