## CARATTERISTICHE PRINCIPALI

Le funzionalità chiave del componente sono:

* La possibilità di personalizzare l'aspetto e il comportamento del pulsante
* Il supporto per diversi tipi di pulsanti (primario, secondario, disabilitato)
* La possibilità di aggiungere icone o testo al pulsante

Gli aspetti tecnici rilevanti sono:

* Il componente è realizzato utilizzando HTML e CSS
* È possibile personalizzare l'aspetto del componente utilizzando classi CSS

Le caratteristiche di accessibilità sono:

* Il componente è accessibile tramite tastiera
* Il componente supporta la navigazione con il mouse e la tastiera

## VARIANTI

Le varianti disponibili per il componente sono:

* **Primario**: pulsante principale utilizzato per azioni importanti
	+ Casi d'uso: inviare un modulo, confermare un'azione
	+ Descrizione breve: pulsante principale con sfondo colorato e testo bianco
* **Secondario**: pulsante secondario utilizzato per azioni meno importanti
	+ Casi d'uso: annullare un'azione, tornare indietro
	+ Descrizione breve: pulsante secondario con sfondo grigio e testo nero
* **Disabilitato**: pulsante disabilitato che non può essere cliccato
	+ Casi d'uso: quando un'azione non è disponibile o non è possibile eseguirla
	+ Descrizione breve: pulsante disabilitato con sfondo grigio e testo nero

## BEST PRACTICES

Le raccomandazioni d'uso sono:

* Utilizzare il componente per azioni importanti o principali
* Personalizzare l'aspetto del componente utilizzando classi CSS
* Utilizzare il componente in modo coerente all'interno dell'applicazione

Le linee guida implementative sono:

* Utilizzare HTML e CSS per realizzare il componente
* Utilizzare classi CSS per personalizzare l'aspetto del componente

Le pratiche da evitare sono:

* Utilizzare il componente per azioni non importanti o secondarie
* Non personalizzare l'aspetto del componente utilizzando classi CSS

## COMPONENTI CORRELATI

I componenti associati sono:

* Form: il componente può essere utilizzato all'interno di un modulo per inviare dati
* Icone: il componente può essere utilizzato con icone per fornire una rappresentazione visiva dell'azione

Le relazioni con altri elementi sono:

* Il componente può essere utilizzato in combinazione con altri componenti per creare un'interfaccia utente coerente.