import{a as l}from"./iframe-4Ua0A6k5.js";import"./preload-helper-PPVm8Dsz.js";const c=`L'etichetta del form deve essere sempre fuori dal campo. Se il campo è “obbligatorio” devono essere inseriti: il simbolo “*” dopo dell'Etichetta (label) del Campo, l'attributo \`aria-required="true"\` nel tag input, select o textarea e,prima del form, la leggenda "I campi contrassegnati con l’asterisco (*) sono obbligatori."

All'interno del box deve sempre esserci un'indicazione del valore da inserire.

L'errore di compilazione deve essere sempre composto da:
- campo evidenziato
- descrizione dell'errore chiara per qualsiasi utente. Evitare quindi di scrivere frasi come “Errore Generico”

Si suggerisce di inserire, nei form più complessi, un tooltip per fornire maggiori indicazioni sul valore da inserire.
`,d=`**PANORAMICA**  
- **Descrizione generale**: Il componente Button rappresenta un elemento interattivo che consente agli utenti di eseguire azioni o triggerare eventi all'interno di un'interfaccia web.
- **Funzionalità principali**: Offre un'ampia gamma di varianti stilistiche e dimensioni per adattarsi a diversi contesti d'uso, garantendo coerenza e accessibilità.

**CASO D'USO**  
- **Scenari di utilizzo principali**: Utilizzato per inviare moduli, avviare processi, navigare tra pagine o eseguire qualsiasi azione definita dall'applicazione.
- **Contesto di implementazione consigliato**: Ideale in qualsiasi punto dell'interfaccia dove è richiesta un'interazione utente per eseguire un'azione specifica.
- **Posizionamento ideale nell'interfaccia**: Può essere posizionato in moduli, toolbar, dialoghi o come call-to-action prominente nelle pagine.

**CARATTERISTICHE PRINCIPALI**  
- **Funzionalità chiave**:
  - Supporto per varianti di stile: primario, secondario, successo, pericolo, avviso, informazione, luce, scuro.
  - Dimensioni personalizzabili: piccolo, medio, grande.
  - Stato disabilitato per indicare azioni non disponibili.
- **Aspetti tecnici rilevanti**: Implementato utilizzando l'elemento \`<button>\` o \`<a>\` con ruoli e attributi appropriati per garantire l'accessibilità.
- **Caratteristiche di accessibilità**: Progettato per essere completamente navigabile tramite tastiera e compatibile con screen reader, includendo attributi ARIA quando necessario.

**VARIANTI**  
- **Elenco e descrizione delle varianti disponibili**:
  - Stili: primario, secondario, successo, pericolo, avviso, informazione, luce, scuro.
  - Dimensioni: piccolo, medio, grande.
- **Casi d'uso specifici per ogni variante**:
  - Stili diversi per indicare l'importanza o la natura dell'azione.
  - Dimensioni diverse per adattarsi a spazi specifici nell'interfaccia.

**PROPRIETÀ**  
- **Proprietà configurabili**:
  - \`type\`: specifica il tipo di pulsante (\`button\`, \`submit\`, \`reset\`).
  - \`disabled\`: disabilita l'interazione con il pulsante.
  - \`aria-label\`: fornisce un'etichetta accessibile per il pulsante.
- **Parametri disponibili**: Possibilità di aggiungere attributi personalizzati per estendere la funzionalità.
- **Attributi per l'accessibilità**: Utilizzo di \`aria-label\` o \`aria-labelledby\` per descrivere l'azione del pulsante.

**DETTAGLI DI IMPLEMENTAZIONE**  
- **Struttura HTML**: Il pulsante è rappresentato da un elemento \`<button>\` o \`<a>\` con classi specifiche per lo stile e attributi per l'accessibilità.
- **Stile e CSS utilizzati**: Utilizza classi CSS per gestire il layout e l'aspetto, garantendo coerenza con il design system.
- **Variabili CSS disponibili e loro funzione**:
  - \`--btn-padding\`: padding interno del pulsante.
  - \`--btn-font-size\`: dimensione del testo del pulsante.
  - \`--btn-border-radius\`: raggio dei bordi del pulsante.
  - \`--btn-background-color\`: colore di sfondo del pulsante.
  - \`--btn-text-color\`: colore del testo del pulsante.

**BEST PRACTICES**  
- **Raccomandazioni d'uso**:
  - Utilizzare etichette chiare e concise che descrivano l'azione del pulsante.
  - Assicurarsi che il pulsante sia facilmente identificabile e distinguibile dagli altri elementi.
- **Linee guida implementative**: Evitare di utilizzare pulsanti per navigare tra pagine; preferire link per la navigazione.
- **Pratiche da evitare**: Evitare di utilizzare pulsanti senza etichette o con etichette ambigue.

**LINEE GUIDA PER L'ACCESSIBILITÀ**  
- **Requisiti di accessibilità**: Assicurarsi che il pulsante sia navigabile tramite tastiera e che abbia un'etichetta descrittiva.
- **Supporto tastiera**: Il pulsante deve essere attivabile tramite la barra spaziatrice o Invio.
- **Configurazione screen reader**: Utilizzare attributi ARIA per fornire informazioni sul contesto e la funzione del pulsante.

**COMPONENTI CORRELATI**  
- **Componenti associati**: Button Group, Toolbar, Icon Button.
- **Relazioni con altri elementi**: Spesso utilizzato all'interno di moduli, dialoghi o come call-to-action nelle pagine.
`;function p(e){return`      
      <div class="row">
        <div class="col-12 col-sm-8 col-md-6 col-lg-6">
          <span class="inail-tag-default tag-${e.tipo}">
            <span class="inail-tag-text">${e.etichetta}</span>
          </span>
        </div>
      </div>`}function g(e){return`      
      <div class="row">
        <div class="col-12 col-sm-8 col-md-6 col-lg-6">
          <span class="inail-tag-default tag-primary">
            <span class="inail-tag-text">${e.etichetta}</span>
          </span>
        </div>
      </div>`}function u(e){return`      
      <div class="row">
        <div class="col-12 col-sm-8 col-md-6 col-lg-6">
          <span class="inail-tag-default tag-success">
          <span class="sr-only">tag successo</span>
          <span class="fa-solid fa-circle-check inail-tag-icon" aria-hidden="true"></span>
            <span class="inail-tag-text">${e.etichetta}</span>
          </span>
        </div>
      </div>`}function m(e){return`      
      <div class="row">
        <div class="col-12 col-sm-8 col-md-6 col-lg-6">
          <span class="tag-info inail-tag-default" aria-label="tag info">
          <span class="sr-only">tag info</span>
         <span class="fa-solid fa-circle-info inail-tag-icon" aria-hidden="true"></span>
          <span class="inail-tag-text">${e.etichetta}</span>
          </span>
        </div>
      </div>`}function z(e){return`      
      <div class="row">
        <div class="col-12 col-sm-8 col-md-6 col-lg-6">
          <span class="inail-tag-default tag-warning"  aria-label="tag avviso">
          <span class="sr-only">tag avviso</span>
           <span class="fa-solid fa-circle-exclamation inail-tag-icon" aria-hidden="true"></span>
            <span class="inail-tag-text">${e.etichetta}</span>
          </span>
        </div>
      </div>`}function v(e){return`      
      <div class="row">
        <div class="col-12 col-sm-8 col-md-6 col-lg-6">
          <span class="inail-tag-default tag-danger" aria-label="tag errore">
          <span class="sr-only">tag errore</span>
            <span class="fa-solid fa-triangle-exclamation inail-tag-icon"></span>
            <span class="inail-tag-text">${e.etichetta}</span>
          </span>
        </div>
      </div>`}const b={title:"Componenti/Tags",parameters:{docs:{description:{component:d},mdxPage:c}},decorators:[(e,s)=>l(e,s,6,["https://linneoclass.it/app/webkit/unico/static-webkit/js/custom-webkit.js"],!0),e=>`<main id="contenutoPrincipale">${e()}</main>`]},a={name:"Tag Default",argTypes:{etichetta:{control:"text",description:"Testo visualizzato all’interno del tag"},tipo:{control:"select",options:["default","primary","success","info","warning","danger"],description:"Tipo di tag che determina il colore",table:{defaultValue:{summary:"default"}}}},args:{etichetta:"I campi contrassegnati con l'asterisco (*) sono obbligatori"},render:({...e})=>p(e)},i={name:"Tag Primary",argTypes:{etichetta:{control:"text",description:"Testo visualizzato all’interno del tag"}},args:{etichetta:"I campi contrassegnati con l'asterisco (*) sono obbligatori"},render:({...e})=>g(e)},t={name:"Tag Success",argTypes:{etichetta:{control:"text",description:"Testo visualizzato all’interno del tag"}},args:{etichetta:"Tutti i campi sono corretti"},render:({...e})=>u(e)},n={name:"Tag Info",argTypes:{etichetta:{control:"text",description:"Testo visualizzato all’interno del tag"}},args:{etichetta:"Il numero di postazioni deve essere maggiore di 8"},render:({...e})=>m(e)},r={name:"Tag Warning",argTypes:{etichetta:{control:"text",description:"Testo visualizzato all’interno del tag"}},args:{etichetta:"Attenzione: verificare con cura i dati inseriti prima di procedere"},render:({...e})=>z(e)},o={name:"Tag Danger",argTypes:{etichetta:{control:"text",description:"Testo visualizzato all’interno del tag"}},args:{etichetta:"Errore nell'inserimento"},render:({...e})=>v(e)};a.parameters={...a.parameters,docs:{...a.parameters?.docs,source:{originalSource:`{
  name: "Tag Default",
  argTypes: {
    etichetta: {
      control: 'text',
      description: 'Testo visualizzato all’interno del tag'
    },
    tipo: {
      control: 'select',
      options: ['default', 'primary', 'success', 'info', 'warning', 'danger'],
      description: 'Tipo di tag che determina il colore',
      table: {
        defaultValue: {
          summary: 'default'
        }
      }
    }
  },
  args: {
    etichetta: "I campi contrassegnati con l'asterisco (*) sono obbligatori"
  },
  render: ({
    ...args
  }) => createTagDefault(args)
}`,...a.parameters?.docs?.source}}};i.parameters={...i.parameters,docs:{...i.parameters?.docs,source:{originalSource:`{
  name: "Tag Primary",
  argTypes: {
    etichetta: {
      control: 'text',
      description: 'Testo visualizzato all’interno del tag'
    }
  },
  args: {
    etichetta: "I campi contrassegnati con l'asterisco (*) sono obbligatori"
  },
  render: ({
    ...args
  }) => createTagPrimary(args)
}`,...i.parameters?.docs?.source}}};t.parameters={...t.parameters,docs:{...t.parameters?.docs,source:{originalSource:`{
  name: "Tag Success",
  argTypes: {
    etichetta: {
      control: 'text',
      description: 'Testo visualizzato all’interno del tag'
    }
  },
  args: {
    etichetta: "Tutti i campi sono corretti"
  },
  render: ({
    ...args
  }) => createTagSuccess(args)
}`,...t.parameters?.docs?.source}}};n.parameters={...n.parameters,docs:{...n.parameters?.docs,source:{originalSource:`{
  name: "Tag Info",
  argTypes: {
    etichetta: {
      control: 'text',
      description: 'Testo visualizzato all’interno del tag'
    }
  },
  args: {
    etichetta: "Il numero di postazioni deve essere maggiore di 8"
  },
  render: ({
    ...args
  }) => createTagInfo(args)
}`,...n.parameters?.docs?.source}}};r.parameters={...r.parameters,docs:{...r.parameters?.docs,source:{originalSource:`{
  name: "Tag Warning",
  argTypes: {
    etichetta: {
      control: 'text',
      description: 'Testo visualizzato all’interno del tag'
    }
  },
  args: {
    etichetta: "Attenzione: verificare con cura i dati inseriti prima di procedere"
  },
  render: ({
    ...args
  }) => createTagWarning(args)
}`,...r.parameters?.docs?.source}}};o.parameters={...o.parameters,docs:{...o.parameters?.docs,source:{originalSource:`{
  name: "Tag Danger",
  argTypes: {
    etichetta: {
      control: 'text',
      description: 'Testo visualizzato all’interno del tag'
    }
  },
  args: {
    etichetta: "Errore nell'inserimento"
  },
  render: ({
    ...args
  }) => createTagDanger(args)
}`,...o.parameters?.docs?.source}}};const h=["TagDefault","TagPrimary","TagSuccess","TagInfo","TagWarning","TagDanger"];export{o as TagDanger,a as TagDefault,n as TagInfo,i as TagPrimary,t as TagSuccess,r as TagWarning,h as __namedExportsOrder,b as default};
