## CARATTERISTICHE PRINCIPALI

Le caratteristiche principali della tabella dinamica includono:

* **Funzionalità chiave**: la tabella dinamica consente di gestire grandi quantità di dati e di fornire una rappresentazione flessibile e personalizzabile dei dati.
* **Aspetti tecnici rilevanti**: la tabella dinamica è stata realizzata utilizzando tecnologie web come HTML, CSS e JavaScript. È possibile personalizzare l'aspetto e il comportamento della tabella mediante l'utilizzo di classi CSS e funzioni JavaScript.
* **Caratteristiche di accessibilità**: la tabella dinamica è stata progettata per essere accessibile agli utenti con disabilità, in conformità con le linee guida WCAG 2.1.

## VARIANTI

La tabella dinamica dispone delle seguenti varianti:

* **Variante 1: Visualizzazione dati di base**: questa variante consente di visualizzare i dati in forma tabellare, senza alcuna personalizzazione.
* **Variante 2: Filtraggio dati**: questa variante consente di filtrare i dati in base a criteri specifici, come ad esempio la ricerca per parole chiave o la selezione di colonne specifiche.
* **Variante 3: Ordinamento dati**: questa variante consente di ordinare i dati in base a colonne specifiche, come ad esempio l'ordinamento alfabetico o numerico.
* **Variante 4: Paginazione dati**: questa variante consente di visualizzare i dati in più pagine, con la possibilità di navigare tra le pagine mediante l'utilizzo di pulsanti di navigazione.

## BEST PRACTICES

Le raccomandazioni d'uso per la tabella dinamica includono:

* Utilizzare la tabella dinamica per visualizzare grandi quantità di dati in forma tabellare.
* Personalizzare l'aspetto e il comportamento della tabella mediante l'utilizzo di classi CSS e funzioni JavaScript.
* Assicurarsi che la tabella sia accessibile agli utenti con disabilità, in conformità con le linee guida WCAG 2.1.

Le linee guida implementative includono:

* Utilizzare tecnologie web come HTML, CSS e JavaScript per realizzare la tabella dinamica.
* Utilizzare classi CSS per personalizzare l'aspetto della tabella.
* Utilizzare funzioni JavaScript per gestire gli eventi e le interazioni con la tabella.

Le pratiche da evitare includono:

* Non utilizzare la tabella dinamica per visualizzare piccole quantità di dati, in quanto ciò potrebbe rendere la tabella non utile.
* Non personalizzare eccessivamente l'aspetto e il comportamento della tabella, in quanto ciò potrebbe renderla difficile da utilizzare.

## COMPONENTI CORRELATI

La tabella dinamica è associata ai seguenti componenti:

* **Header**: il componente header consente di visualizzare le colonne della tabella.
* **Footer**: il componente footer consente di visualizzare le informazioni relative alla paginazione dei dati.
* **Righe**: il componente riga consente di visualizzare i dati in forma tabellare.

**Note**

N.D.

## OVERVIEW
<div class="table-responsive">`import { TableResultComponent } from '@inail/internet-webkit/tables';`</div>
Componente custom usato per costruire tabelle. In questo caso, basta usare solo parti del componente del webkit per costruire una variazione semplice della tabella.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
  <tr>
    <th style="width: 20%"><strong>Campo</strong></th>
    <th style="width: 80%"><strong>Descrizione</strong></th>
  </tr>
  </thead>
  <tbody>
  <tr>
    <td><code>title</code></td>
    <td>
      `@Input() title!: string;` <br />
      Titolo visualizzato sopra la tabella.
    </td>
  </tr>
  <tr>
    <td><code>description</code></td>
    <td>
      `@Input() description!: string;` <br />
      Descrizione della tabella mostrata sotto il titolo.
    </td>
  </tr>
  <tr>
    <td><code>results</code></td>
    <td>
      `@Input('results') set manageResultInput(result: any[]) {}` <br />
      Un array di oggetti che vengono mostrati nella tabella come elementi. Per informazioni più approfondite fare riferimento alla documentazione di <a href="?path=/docs/resources-models-results--docs">results</a>
    </td>
  </tr>
  <tr>
    <td><code>tableStructure</code></td>
    <td>
      `@Input('structure') tableStructure: any[] = [];` <br />
      Un array che costruisce la struttura della tabella. L' array contiene elementi di tipo <a href="?path=/docs/resources-models-tablefield--docs">TableField</a> che rappresentano le colonne, e, facoltativamente, è possibile aggiungere un ultimo oggetto <a href="?path=/docs/resources-models-actionsfield--docs">ActionsField</a>  che rappresenta la colonna delle azioni della tabella.
      `const tableStructure = [
        new TableField('Colonna 1', true, 'NORMAL', 'name', false),
        new TableField('Colonna 2', false, 'NORMAL', 'size', false),
        new ActionsField('', [
          new ActionItem(
            'BUTTON.EDIT_STEP',
            (actions: ActionItem, item: any) => {
              action('onEdit')('');
            },
            ['pencil']
          ),
        ]),
];`
    </td>
  </tr>
  <tr>
    <td><code>showPageSize</code></td>
    <td>
      `@Input() showPageSize: true;` <br />
      Booleano utilizzato per mostrare/nascondere il numero di elementi per pagina della tabella.
    </td>
  </tr>
  <tr>
    <td><code>bordered</code></td>
    <td>
      `@Input() bordered: true;` <br />
      Booleano utilizzato per mostrare/nascondere le divisioni delle righe e colonne della tabella.
    </td>
  </tr>
  <tr>
    <td><code>stripped</code></td>
    <td>
      `@Input() stripped: true;` <br />
      Booleano utilizzato per applicare la classe CSS `table-striped`.
    </td>
  </tr>
  <tr>
    <td><code>bgWhite</code></td>
    <td>
      `@Input() bgWhite: true;` <br />
      Booleano utilizzato per impostare uno sfondo bianco quando impostato su true, o trasparente quando impostato su false.
    </td>
  </tr>
	<tr>
	  <td><code>loading</code></td>
	  <td>
		  `@Input() loading: false;` <br />
		  Booleano utilizzato per mostrare uno stato di caricamento dei dati nella tabella.
	  </td>
	</tr>
	<tr>
	  <td><code>hover</code></td>
	  <td>
		  `@Input() hover: true;` <br />
		  Booleano utilizzato per abilitare l'effetto del passaggio del mouse sulle righe.
	  </td>
	</tr>
	<tr>
	  <td><code>totalElements</code></td>
	  <td>
		  `@Input() totalElements!: number | undefined;` <br />
		  Campo numerico che imposta e mostra il numero totale di elementi nella tabella.
	  </td>
	</tr>
	<tr>
	  <td><code>numElementsToShow</code></td>
	  <td>
		  `@Input() numElementsToShow!: number | undefined;` <br />
		  Campo numerico che imposta e mostra il numero totale di elementi per pagina nella tabella.
	  </td>
	</tr>
	<tr>
	  <td><code>showPageSize</code></td>
	  <td>
		  `@Input() showPageSize: true;` <br />
		  Booleano che mostra il selettore di dimensione della pagina quando è attivo.
	  </td>
	</tr>
	<tr>
	  <td><code>sortColumn</code></td>
	  <td>
		  `@Input() sortColumn!: string;` <br />
		  Campo che imposta la colonna utilizzata per l'ordinamento.
	  </td>
	</tr>
	<tr>
	  <td><code>sortType</code></td>
	  <td>
		  `@Input() set sortType(value: SortType) {}` <br />
		  Campo che imposta la direzione di ordinamento dei dati della tabella. Può essere `"asc"` o `"desc"`.
	  </td>
	</tr>
	<tr>
	  <td><code>totalPages</code></td>
	  <td>
		  `@Input() set totalPages(num: number | undefined) {}` <br />
		  Campo numerico che imposta e mostra il numero di pagine in totale nella paginazione.
	  </td>
	</tr>
  </tbody>
</table>
</div>

<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Event</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>onPageChanged</code></td>
      <td>
        `@Output('onPageChanged') _onPageChanged: EventEmitter<number> = new EventEmitter<number>();` <br />
        `EventEmitter` tramite il quale si può gestire il cambio della pagina di elementi.
      </td>
    </tr>
    <tr>
      <td><code>onPageSizeChange</code></td>
      <td>
        `@Output('onPageSizeChange') _onPageSizeChange: EventEmitter<number> = new EventEmitter<number>();` <br />
        Evento emesso quando cambia il numero di elementi visibili per pagina.
      </td>
    </tr>
    <tr>
      <td><code>onSortChange</code></td>
      <td>
        `@Output('onSortChange') _onSortChange: EventEmitter<string> = new EventEmitter<string>();` <br />
        Evento emesso quando cambia l'ordinamento degli elementi.
      </td>
    </tr>
  </tbody>
</table>
</div>