## CARATTERISTICHE PRINCIPALI
Le caratteristiche principali del componente Button e Link includono:

* Funzionalità chiave: il componente supporta diverse proprietà, come ad esempio `propertyName`, `summary` e `defaultValue`, che consentono di personalizzare il comportamento del bottone.
* Aspetti tecnici rilevanti: il componente è stato progettato per essere utilizzato in diverse piattaforme e dispositivi, quindi è importante considerare gli aspetti tecnici come la compatibilità con diversi browser e sistemi operativi.
* Caratteristiche di accessibilità: il componente supporta le funzionalità di accessibilità come l'utilizzo di etichette e descrizioni per migliorare la navigazione per gli utenti con disabilità.

## VARIANTI
Le varianti del componente Button e Link includono:

* **Link Semplice**: un link semplice che consente di navigare verso una nuova pagina.
* **Link Mailto**: un link che consente di inviare un'email a un indirizzo specifico.
* **Link Esterno**: un link che consente di aprire una nuova finestra o scheda con un URL esterno.
* **Download**: un link che consente di scaricare un file.
* **Link Disabilitato**: un link disabilitato che non consente di eseguire azioni.
* **Tasto Icona Sx**: un bottone con un'icona a sinistra.
* **Tasto Icona Dx**: un bottone con un'icona a destra.

## BEST PRACTICES
Le raccomandazioni d'uso del componente Button e Link includono:

* Utilizzare il componente in modo coerente all'interno dell'applicazione per garantire una esperienza utente uniforme.
* Personalizzare il testo e lo stile del bottone per adattarlo alle esigenze specifiche dell'applicazione.
* Utilizzare icone e immagini per migliorare la visibilità del bottone.

## COMPONENTI CORRELATI
I componenti associati al componente Button e Link includono:

* **Componente Form**: il componente Button e Link può essere utilizzato all'interno di un form per eseguire azioni specifiche.
* **Componente Navbar**: il componente Button e Link può essere utilizzato nella navbar per fornire link di navigazione.

## ACCESSIBILITA'

le informazioni contenute nel tooltip non essendo direttamente visibili sulla schermata, il tooltip non deve essere utilizzato per veicolare informazioni indispensabili all’utente. Inoltre, al focus da tastiera il tooltip deve aprirsi automaticamente ed essere letto dallo screen reader.

Lo scopo dei link deve essere comprensibile dall’utente “fuori dal contesto”, ovvero mettendo da parte il link e “isolandolo” dai contenuti che lo circondano sulla schermata. Alcuni utenti non vedenti si spostano tra i link presenti in pagina, essi devono essere dunque significativi anche per chi non vede il contenuto attorno al link (per esempio la frase all’interno della quale il link è inserito.) Queste informazioni aggiuntive possono essere inserite tramite tooltip. Lo SR leggerà, dopo aver letto l’etichetta testuale del link, il contenuto del
tooltip (che non deve quindi comprendere l’etichetta testuale per evitare ridondanze).
