## CARATTERISTICHE PRINCIPALI

Le funzionalità chiave del componente Input Messages includono:

* Possibilità di personalizzare i messaggi di errore e avviso
* Supporto per la visualizzazione di più messaggi contemporaneamente
* Possibilità di nascondere o mostrare i messaggi in base alle esigenze dell'applicazione

Gli aspetti tecnici rilevanti del componente Input Messages includono:

* Utilizzo di un oggetto JSON per memorizzare le informazioni sui messaggi
* Possibilità di configurare il comportamento del componente tramite proprietà e attributi

Le caratteristiche di accessibilità del componente Input Messages includono:

* Supporto per la lettura dei messaggi da parte degli screen reader
* Utilizzo di colori e stili che rispettano gli standard di accessibilità

## VARIANTI

Sono disponibili due varianti del componente Input Messages:

* **Variante 1:** Visualizzazione di un singolo messaggio di errore
 + Caso d'uso: quando si desidera visualizzare un messaggio di errore per un campo di input specifico
 + Breve descrizione: il componente visualizza un messaggio di errore personalizzato per il campo di input selezionato
* **Variante 2:** Visualizzazione di più messaggi contemporaneamente
 + Caso d'uso: quando si desidera visualizzare più messaggi di errore o avviso per più campi di input
 + Breve descrizione: il componente visualizza una lista di messaggi personalizzati per i campi di input selezionati

## BEST PRACTICES

Le raccomandazioni d'uso del componente Input Messages includono:

* Utilizzare il componente per fornire feedback immediato agli utenti durante l'interazione con i campi di input
* Personalizzare i messaggi di errore e avviso per adattarli alle esigenze specifiche dell'applicazione

Le linee guida implementative del componente Input Messages includono:

* Utilizzare un oggetto JSON per memorizzare le informazioni sui messaggi
* Configurare il comportamento del componente tramite proprietà e attributi

Le pratiche da evitare quando si utilizza il componente Input Messages includono:

* Non utilizzare il componente per visualizzare messaggi non pertinenti o non rilevanti per l'utente

## COMPONENTI CORRELATI

Il componente Input Messages è spesso utilizzato in combinazione con altri componenti dell'interfaccia utente, come ad esempio:

* Campi di input
* Pulsanti di submit
* Messaggi di conferma

Le relazioni tra il componente Input Messages e questi altri componenti includono:

* Il componente Input Messages fornisce feedback immediato agli utenti durante l'interazione con i campi di input
* I pulsanti di submit possono essere utilizzati per inviare i dati dell'utente al server dopo che gli errori sono stati corretti
* I messaggi di conferma possono essere utilizzati per fornire ulteriore feedback agli utenti dopo che le loro azioni sono state completate con successo.

## OVERVIEW
<div class="table-responsive">`import { InputMessagesComponent } from '@inail/internet-webkit/form-controls';`</div>

Il componente `InputMessagesComponent` viene utilizzato per visualizzare messaggi di errore, avvisi e supporto relativi a un campo di input. Consente di fornire un feedback chiaro e utile all'utente durante l'interazione con i moduli, migliorando l'usabilità e l'accessibilità del sistema. 

## API
<div class="table-responsive">
  <table class="table">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>inailInputMessages</code></td>
         <td>
            `@Input('inailInputMessages') control: AbstractControl ;` <br />
            Il controllo del modulo a cui sono associati i messaggi di errore e supporto.
         </td>
      </tr>
      <tr>
         <td><code>errors</code></td>
         <td>
            `@Input() errors: Array<ErrorLabel>;` <br />
            Un elenco di messaggi di errore personalizzati associati al controllo del modulo.
         </td>
      </tr>
       <tr>
         <td><code>warning</code></td>
         <td>
            `@Input() warning!: string;` <br />
            Un messaggio di avviso da mostrare quando necessario per guidare l'utente.
         </td>
      </tr>
       <tr>
         <td><code>support</code></td>
         <td>
            `@Input() support!: string;` <br />
            Un messaggio di supporto che fornisce indicazioni aggiuntive all'utente su come compilare il campo di input.
         </td>
      </tr>
       <tr>
         <td><code>inputId</code></td>
         <td>
            `@Input() inputId!: string;` <br />
            L'ID univoco assegnato all'elemento di input per l'associazione con le etichette e i messaggi.
         </td>
      </tr>
       <tr>
         <td><code>removeMessagesSpace</code></td>
         <td>
            `@Input() removeMessagesSpace!: boolean;` <br />
            Se impostato su `true`, rimuove lo spazio riservato ai messaggi sotto il campo di input.
         </td>
      </tr>
       <tr>
         <td><code>label</code></td>
         <td>
            `@Input() label = '';` <br />
            L'etichetta associata all'input per fornire una descrizione chiara.
         </td>
      </tr>
   </tbody>
</table>
</div>