## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente TextArea includono:

* Inserimento di testo multi-riga con possibilità di impostare un limite massimo di caratteri
* Possibilità di abilitare/disabilitare la modifica del testo
* Supporto per l'accessibilità attraverso l'utilizzo di attributi ARIA

Gli aspetti tecnici rilevanti includono:

* Il componente utilizza il tag HTML `textarea` per rendere il campo di testo multi-riga
* È possibile impostare gli attributi `rows` e `cols` per definire le dimensioni del campo di testo

Le caratteristiche di accessibilità includono:

* Supporto per l'accessibilità attraverso l'utilizzo di attributi ARIA
* Possibilità di utilizzare tasti di scelta rapida per navigare all'interno del campo di testo

## VARIANTI
Il componente TextArea dispone delle seguenti varianti:

* **Base**: la variante base del componente, che include tutte le funzionalità principali
* **Disabled**: una variante che disabilita la modifica del testo
* **Readonly**: una variante che rende il testo solo di lettura

Per ogni variante, sono disponibili i seguenti casi d'uso:

* Utilizzare la variante base per inserire testo libero
* Utilizzare la variante disabled per disabilitare la modifica del testo in situazioni specifiche
* Utilizzare la variante readonly per rendere il testo solo di lettura

## BEST PRACTICES
Le raccomandazioni d'uso includono:

* Utilizzare il componente TextArea per inserire testo lungo, come ad esempio descrizioni o commenti
* Impostare un limite massimo di caratteri per evitare che gli utenti inseriscano troppo testo
* Utilizzare gli attributi ARIA per supportare l'accessibilità

Le linee guida implementative includono:

* Utilizzare il tag HTML `textarea` per rendere il campo di testo multi-riga
* Impostare gli attributi `rows` e `cols` per definire le dimensioni del campo di testo

Le pratiche da evitare includono:

* Non utilizzare il componente TextArea per inserire testo breve, come ad esempio titoli o etichette
* Non disabilitare la modifica del testo senza una ragione valida

## COMPONENTI CORRELATI
Il componente TextArea è correlato ai seguenti componenti:

* **InputLabel**: un componente che fornisce un'etichetta per il campo di testo
* **Button**: un componente che può essere utilizzato per inviare il testo inserito nel campo di testo

Le relazioni con altri elementi includono:

* Il componente TextArea può essere utilizzato all'interno di un modulo per raccogliere dati dagli utenti
* Il componente TextArea può essere utilizzato in combinazione con altri componenti, come ad esempio il componente InputLabel, per fornire un' interfaccia utente completa.

## OVERVIEW
<div class="table-responsive">`import { TextAreaComponent } from '@inail/internet-webkit/form-controls';`</div>

Il componente Text Area è progettato per offrire un modo semplice e intuitivo per consentire agli utenti di inserire testo di lunghezza variabile all'interno di un'interfaccia utente. È ideale per raccogliere input più estesi, come commenti, descrizioni e messaggi.


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>maxLength</code></td>
      <td>
        `@Input() maxLength = 300;` <br />
        Numero massimo di caratteri consentiti nell'area di testo.
      </td>
    </tr>
    <tr>
      <td><code>rows</code></td>
      <td>
        `@Input() rows = 5;` <br />
        Numero di righe visibili nell'area di testo.
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class TextAreaComponent extends BaseInputComponent` <br />
        Fare riferimento a <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent.</a>
      </td>
    </tr>
  <tr>
    <td><code>size</code></td>
    <td>
    `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
    La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
    </td>
  </tr>
  </tbody>
</table>
</div>