## CARATTERISTICHE PRINCIPALI
Le caratteristiche chiave del Button Card sono:

* Funzionalità di evento: il componente emette un evento al click sul pulsante, che può essere gestito dall'applicazione
* Aspetti tecnici rilevanti: il componente utilizza la proprietà "onClick" per definire l'azione da eseguire al click
* Caratteristiche di accessibilità: N.D.

## VARIANTI
Le varianti disponibili per il Button Card sono:

* **Default**: la variante predefinita del pulsante, senza alcuna personalizzazione
	+ Caso d'uso: utilizzare il pulsante come link o per eseguire un'azione semplice
	+ Descrizione breve: pulsante standard con layout di carta

## BEST PRACTICES
Le raccomandazioni d'uso per il Button Card sono:

* Utilizzare il componente per azioni semplici e intuitive, come ad esempio aprire una pagina o eseguire un'azione
* Evitare di utilizzare il componente per azioni complesse o che richiedono molta attenzione da parte dell'utente

Le linee guida implementative sono:

* Utilizzare la proprietà "onClick" per definire l'azione da eseguire al click sul pulsante
* Personalizzare il testo e le icone all'interno del pulsante in base alle esigenze dell'applicazione

## COMPONENTI CORRELATI
Il Button Card non ha componenti associati diretti. Tuttavia, può essere utilizzato in combinazione con altri componenti per creare layout più complessi e interattivi.

Nota: le informazioni disponibili sul componente sono limitate, quindi alcune sezioni potrebbero essere vuote o incomplete.

## OVERVIEW
<div class="table-responsive">`import { ButtonCardComponent } from '@inail/internet-webkit/elements';`</div>
<br />
Il componente ButtonCard viene utilizzato all'interno di una card per eseguire azioni specifiche. Può essere configurato tramite la proprietà di onClick per la gestione degli eventi.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Event</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>manageClick</code></td>
      <td>
        `@Output() onClick: EventEmitter<boolean> = new EventEmitter<boolean>();` <br />
        `EventEmitter` tramite il quale si può gestire la logica del click sul button.
      </td>
    </tr>
  </tbody>
</table>
</div>