## CARATTERISTICHE PRINCIPALI

* **Funzionalità chiave**: il componente supporta la visualizzazione di testo e icone, nonché la possibilità di personalizzare lo stile e il layout.
* **Aspetti tecnici rilevanti**: il componente è realizzato utilizzando tecnologie web standard (HTML, CSS, JavaScript) e può essere integrato in applicazioni web moderne.
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile agli utenti con disabilità, seguendo le linee guida WCAG 2.1.

## VARIANTI

Il componente presenta diverse varianti, ognuna con caratteristiche e casi d'uso specifici:

* **Conferma**: variante utilizzata per confermare un'azione o una scelta.
* **Disabilitato**: variante utilizzata per rappresentare un bottone disabilitato.
* **Icona allineata a sinistra**: variante che posiziona l'icona a sinistra del testo.
* **Icona allineata a destra**: variante che posiziona l'icona a destra del testo.

Ogni variante ha un breve descrizione:
* Conferma: "Conferma un'azione o una scelta"
* Disabilitato: "Rappresenta un bottone disabilitato"
* Icona allineata a sinistra: "Posiziona l'icona a sinistra del testo"
* Icona allineata a destra: "Posiziona l'icona a destra del testo"

## BEST PRACTICES

* **Raccomandazioni d'uso**: utilizzare il componente per rappresentare azioni o collegamenti importanti in una pagina web.
* **Linee guida implementative**: seguire le linee guida di design e sviluppo dell'applicazione per garantire la coerenza e l'accessibilità del componente.
* **Pratiche da evitare**: non utilizzare il componente per rappresentare informazioni secondarie o meno importanti.

## COMPONENTI CORRELATI

Il componente Button e Link (Primario) può essere utilizzato in combinazione con altri componenti, come ad esempio:

* Componente di testo: per rappresentare informazioni aggiuntive relative all'azione o al collegamento.
* Componente di immagine: per rappresentare un'immagine relativa all'azione o al collegamento.

## ACCESSIBILITA'
Per i bottoni con sola icona, è obbligatorio configurare l'attributo `aria-label` uguale al valore dell'attributo `data-original-title`.