# TooltipPlaceType

Documentazione dettagliata del tipo **TooltipPlaceType**, utilizzato nei componenti di interfaccia per definire la posizione dei tooltip.
**TooltipPlaceType** specifica le opzioni disponibili per posizionare un tooltip, come top, right, bottom e left.

## Implementazione
<div class="table-responsive">`import { TooltipPlaceType } from '@inail/internet-webkit/constants'`</div>
<br />


***Struttura:***
`type TooltipPlaceType = 'top' | 
'right' | 
'bottom' | 
'left';
`

***Esempio d'uso:***
<br />
<div class="table-responsive">`tooltipPlacement: TooltipPlaceType = TooltipPlacementEnum.LEFT;`</div>

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>'top'</code></td>
      <td>Posiziona il tooltip sopra l'elemento associato.</td>
    </tr>
    <tr>
      <td><code>'right'</code></td>
      <td>Posiziona il tooltip alla destra dell'elemento associato.</td>
    </tr>
    <tr>
      <td><code>'bottom'</code></td>
      <td>Posiziona il tooltip sotto l'elemento associato.</td>
    </tr>
    <tr>
      <td><code>'left'</code></td>
      <td>Posiziona il tooltip alla sinistra dell'elemento associato.</td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-buttons-action--action">Action</a>
<br/>
<a href="?path=/story/components-buttons-actions-dropdown--actions-dropdown">Action Dropdown</a>
<br/>
