## CARATTERISTICHE PRINCIPALI

### Aspetti tecnici rilevanti

* Implementato utilizzando tecnologie web standard (HTML, CSS, JavaScript)
* Utilizza librerie Angular per il rendering dinamico del calendario

### Caratteristiche di accessibilità

* Il componente è progettato per essere accessibile aiutando gli utenti con disabilità motorie o visive.
* Supporta le funzionalità di accessibilità standard del browser, come la navigazione tramite tastiera e la lettura dello schermo.

## BEST PRACTICES

N.D

## COMPONENTI CORRELATI
N.D

## ACCESSIBILITA'
Quando un form ha un titolo visibile, il tag `<form>` deve includere l’attributo `aria-labelledby`, valorizzato con l’ID dell’elemento che contiene il titolo.
Per evitare conflitti tra più form e garantire chiarezza allo screen reader, è obbligatorio assegnare agli ID dei titoli un formato univoco, ad esempio: form_01, form_02, ecc.  Qualora un form venga implementato senza un titolo visibile a schermo, dovrà comunque essere "nominato" per gli screen reader. In questo specifico caso, andrà aggiunto al tag `<form>` un attributo aria-label, valorizzato con il nome descrittivo che si intende assegnare al form. Il `<fieldset>` deve essere inserito solo se il form ha più sezioni, e deve essere accompagnato da un `<legend>` (visibile o meno a schermata a seconda dei casi). Esempio: `<form aria-labelledby=”x”> 
<fieldset> 
<legend> Dati anagrafici </legend> 
Contenuto della sezione “Dati anagrafici” 
</fieldset>
 <fieldset>
<legend>Dati fiscali </legend>
 Contenuto della sezione “Dati fiscali”
  </fieldset> 
  </form>` 
  Se i titoli delle sezioni non devono essere visibile andrà aggiunta la classe `sr-only` al TAG `<legend>`.

  Quando un pulsante ha la funzione di aggiungere nuovi campi a un form, i campi generati devono essere inseriti subito sotto al pulsante e non sopra, così da rispettare l’ordine logico e prevedibile di lettura e navigazione per gli utenti, inclusi quelli con tecnologie assistive.

  Sono presenti due varianti principali di validazione:

- **Validazione immediata**: i campi vengono validati durante la compilazione, ovvero al \`valueChanges\`, fornendo feedback in tempo reale all’utente.
- **Validazione su submit e durante la compilazione**: i messaggi di errore vengono mostrati sia in fase di compilazione dei campi, sia al momento del submit se i campi non sono validi.

E' possibile inserire anche una modalità di validazione più mirata, pensata per quei casi in cui **alcuni controlli debbano essere validati solo al momento del submit**.  
Questo approccio è utile quando si vogliono eseguire verifiche che hanno senso solo a form completo (es. validazioni incrociate o logiche condizionali), evitando di mostrare errori prematuramente durante la compilazione.
