## CARATTERISTICHE PRINCIPALI
Le caratteristiche principali del componente Modal di Conferma sono:

* Funzionalità chiave: visualizzazione di una finestra modale con opzioni di conferma e annullamento
* Aspetti tecnici rilevanti: utilizzo di HTML, CSS e JavaScript per la creazione e gestione della finestra modale
* Caratteristiche di accessibilità: il componente è progettato per essere accessibile agli utenti con disabilità, in conformità con le linee guida WCAG 2.1

## VARIANTI
Il componente Modal di Conferma dispone delle seguenti varianti:

* **Conferma**: questa variante visualizza una finestra modale con un messaggio di conferma e opzioni di conferma e annullamento.
 + Caso d'uso: utilizzare questa variante per richiedere all'utente la conferma di un'azione specifica.
 + Breve descrizione: finestra modale di conferma con opzioni di conferma e annullamento.

## BEST PRACTICES
Le raccomandazioni d'uso del componente Modal di Conferma sono:

* Utilizzare il componente per richiedere all'utente la conferma di un'azione specifica
* Personalizzare il testo della finestra modale in base alle esigenze dell'applicazione
* Gestire gli eventi di conferma e annullamento per eseguire azioni specifiche

Le linee guida implementative sono:

* Utilizzare HTML, CSS e JavaScript per la creazione e gestione della finestra modale
* Seguire le linee guida WCAG 2.1 per garantire l'accessibilità del componente

Le pratiche da evitare sono:

* Non utilizzare il componente per scopi diversi dalla conferma di un'azione specifica
* Non omettere la gestione degli eventi di conferma e annullamento

## COMPONENTI CORRELATI
Il componente Modal di Conferma è correlato ai seguenti componenti:

* **Button**: il componente Button può essere utilizzato per attivare la finestra modale
* **Dialog**: il componente Dialog può essere utilizzato per visualizzare una finestra modale con opzioni di conferma e annullamento

## OVERVIEW
<div class="table-responsive">`import { ConfirmationComponent } from '@inail/intranet-webkit/modals';`</div>
 
Il componente ConfirmationComponent è progettato per gestire conferme in modo semplice e personalizzabile. È ideale per scenari in cui è necessario chiedere conferma all'utente prima di eseguire un'azione, come eliminare un elemento o completare un processo.

Questo componente utilizza un'istanza del ModalComponent per presentare una finestra modale con titolo, messaggi e pulsanti configurabili, consentendo una gestione semplice degli eventi di conferma e annullamento.
 
## API
<div class="table-responsive">
  <table class="table table-documentation">
    <thead>
      <tr>
        <th style="width: 20%"><strong>Campo</strong></th>
        <th style="width: 80%"><strong>Descrizione</strong></th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><code>title</code></td>
        <td> <code>@Input() title: string = 'MESSAGES.CONFIRM_ACTION';</code><br /> Titolo della finestra di conferma. Visualizzato nella parte superiore della modale.<br /> Valore predefinito: <code>'MESSAGES.CONFIRM_ACTION'</code>. </td>
      </tr>
      <tr>
        <td><code>actions</code></td>
        <td> <code>@Input() set actions(actionsInput: ActionItem[]);</code><br /> Configura le azioni disponibili nella finestra di conferma. Accetta un array di oggetti di tipo <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>. </td>
      </tr>
      <tr>
        <td><code>cancel</code></td>
        <td> <code>@Input() set cancel(actionCancel: ActionItem);</code><br /> Configura l'azione di annullamento. Accetta un oggetto di tipo <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>. </td>
      </tr>
    </tbody>
  </table>
</div>

<br />
<br />

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Event</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
        <tr>
       <td><code>onConfirm</code></td>
       <td> <code>@Output('onConfirm') _onConfirm: EventEmitter&lt;any&gt; = new EventEmitter();</code><br /> Evento emesso quando l'utente conferma l'azione. </td>
     </tr>
     <tr>
       <td><code>onCancel</code></td>
       <td> <code>@Output('onCancel') _onCancel: EventEmitter&lt;any&gt; = new EventEmitter();</code><br /> Evento emesso quando l'utente annulla l'azione. </td>
     </tr>
 </tbody>
</table>
</div>