## CARATTERISTICHE PRINCIPALI

Le caratteristiche chiave del componente sono:

- **Funzionalità di azione**: il componente può essere configurato per eseguire una vasta gamma di azioni, come ad esempio la navigazione a un'altra pagina o l'invio di un modulo.
- **Aspetti tecnici rilevanti**: il componente utilizza HTML, CSS e JavaScript per fornire una esperienza utente ricca e interattiva.
- **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile agli utenti con disabilità, grazie all'utilizzo di attributi ARIA e alla conformità con le linee guida WCAG 2.1.

## VARIANTI

Le varianti disponibili per il componente sono:

- **Variante 1: Pulsante di Azione Primario**: utilizzato per azioni principali, come ad esempio la creazione di un nuovo elemento.

* Caso d'uso specifico: utilizzare questo pulsante quando si desidera richiamare l'attenzione dell'utente su un'azione importante.

- **Variante 2: Pulsante di Azione Secondario**: utilizzato per azioni secondarie, come ad esempio la modifica di un elemento esistente.

* Caso d'uso specifico: utilizzare questo pulsante quando si desidera fornire all'utente un modo semplice per eseguire un'azione meno importante.

- **Variante 3: Pulsante di Azione con Icona**: utilizzato per azioni che richiedono un'icona specifica, come ad esempio la stampa di un documento.

* Caso d'uso specifico: utilizzare questo pulsante quando si desidera fornire all'utente un modo visivo per riconoscere l'azione.

## BEST PRACTICES

Le raccomandazioni d'uso per il componente sono:

- Utilizzare il componente in contesti dove è necessario eseguire un'azione specifica.
- Personalizzare il testo e l'icona del pulsante per adattarlo al contesto dell'applicazione.
- Utilizzare gli stati del pulsante (ad esempio, abilitato/disabilitato) per fornire all'utente feedback sulla disponibilità dell'azione.

Le linee guida implementative sono:

- Utilizzare HTML e CSS per creare il componente.
- Utilizzare JavaScript per gestire le azioni del pulsante.

Le pratiche da evitare sono:

- Utilizzare il componente in contesti dove non è necessario eseguire un'azione specifica.
- Non personalizzare il testo e l'icona del pulsante.

## COMPONENTI CORRELATI

I componenti associati al "Pulsante di Azione" sono:

- **Modulo**: utilizzato per raccogliere dati dall'utente.
- **Tabella**: utilizzata per visualizzare dati in forma tabellare.

Le relazioni con altri elementi dell'applicazione sono:

- Il componente può essere utilizzato all'interno di un modulo per eseguire azioni specifiche.
- Il componente può essere utilizzato all'interno di una tabella per eseguire azioni su singole righe.

## ACCESSIBILITA'

Ogni tabella deve avere un titolo letto dallo screen reader e collegato tramite ID e attributo “aria-labelledby” alla sua tabella di riferimento. Qualora fosse necessario nascondere a schermata il titolo, l’attributo “aria-labelledby” posizionato sul TAG `table` andrà sostituito con un attributo “aria-label” valorizzato con il titolo che si vuole dare alla tabella. Il contenitore del titolo visibile andrà eliminato.
