## CARATTERISTICHE PRINCIPALI
Il componente Radio presenta le seguenti caratteristiche principali:

* Funzionalità chiave: la selezione di un'opzione tra più alternative
* Aspetti tecnici rilevanti: il componente utilizza gli attributi HTML standard per la gestione delle opzioni e della selezione
* Caratteristiche di accessibilità: il componente è progettato per essere accessibile agli utenti con disabilità, grazie all'utilizzo di attributi ARIA e alla conformità alle linee guida WCAG 2.1

## VARIANTI
Il componente Radio presenta le seguenti varianti:

* **Test della descrizione del radio**: una variante che include una descrizione dettagliata dell'opzione selezionata
* **INAIL**: una variante che include un set di opzioni specifiche per l'INAIL
* **Radio – Celibe/Nubile Sposato/a Divorziato/a Vedovo/a**: una variante che include un set di opzioni specifiche per lo stato civile

Ciascuna variante presenta i seguenti casi d’uso:

* **Test della descrizione del radio**: utilizzato per fornire informazioni dettagliate sull'opzione selezionata
* **INAIL**: utilizzato per gestire le opzioni specifiche per l'INAIL
* **Radio – Celibe/Nubile Sposato/a Divorziato/a Vedovo/a**: utilizzato per gestire le opzioni specifiche per lo stato civile

## BEST PRACTICES
Per un uso efficace del componente Radio, si raccomanda di:

* Utilizzare il componente in contesti dove è necessario selezionare una sola opzione tra più alternative
* Fornire descrizioni dettagliate delle opzioni disponibili
* Utilizzare gli attributi ARIA per garantire l'accessibilità del componente

## COMPONENTI CORRELATI
Il componente Radio può essere utilizzato in combinazione con altri componenti, come ad esempio:

* **Componente Selezione**: un componente che consente all'utente di selezionare più opzioni tra un set di alternative
* **Componente Casella di controllo**: un componente che consente all’utente di selezionare o deselezionare una o più opzioni

## OVERVIEW
<div class="table-responsive">`import { RadioComponent } from '@inail/intranet-webkit/form-controls';`</div>

Il componente Radio è progettato per offrire una soluzione intuitiva e accessibile per selezionare un'unica opzione tra un gruppo predefinito. E' Ideale per situazioni in cui le scelte sono reciprocamente esclusive.

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
  <tr>
	  <td><code>label</code></td>
	  <td>
		`@Input() label: string;` <br />
        Campo di tipo string che definisce l' ettichetta del radio input.
	  </td>
	</tr>
    <tr>
	  <td><code>id</code></td>
	  <td>
		`@Input() id: string = composeUniqueId('radio');` <br />
        Identificativo univoco generato automaticamente per il componente.
	  </td>
	</tr>
   <tr>
	  <td><code>line</code></td>
	  <td>
		`@Input() line = false;` <br />
		Controlla il layout del componente radio, visualizzandolo come un elemento a block-level quando è false o inline con altri elementi quando è true.
	  </td>
	</tr>
	<tr>
	  <td><code>field-for-id</code></td>
	  <td>
		`@Input('field-for-id') fieldForId: string | undefined;` <br />
		Specificare il nome del campo per estrarre il valore per il form control.
	  </td>
	</tr>
	<tr>
	  <td><code>field-for-option</code></td>
	  <td>
		`@Input('field-for-option') fieldForOptionElement = 'descrizione';` <br />
		Il nome del campo utilizzato per l'etichetta di ciascuna opzione del radio.
	  </td>
	</tr>
    <tr>
	  <td><code>options</code></td>
	  <td>
		`@Input() options(options: RadioOption[])` <br />
		 Gestisce il set delle opzioni disponibili per il componente Radio. 
	  </td>
	</tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class RadioComponent extends BaseInputComponent` <br />
        La classe `RadioComponent` estende  <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent.</a>
      </td>
    </tr>
	<tr>
	  <td><code>size</code></td>
	  <td>
		`@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
		La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
	  </td>
	</tr>
  </tbody>
</table>
</div>