## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente Checkbox sono:

* La possibilità di personalizzare l'aspetto e il comportamento del componente tramite proprietà e attributi
* Il supporto per la gestione degli eventi di clic e cambiamento di stato
* La conformità agli standard di accessibilità per garantire la fruibilità da parte di utenti con disabilità

Gli aspetti tecnici rilevanti del componente Checkbox sono:

* L'utilizzo di HTML, CSS e JavaScript per la sua implementazione
* La possibilità di integrare il componente con altre librerie e framework

Le caratteristiche di accessibilità del componente Checkbox sono:

* Il supporto per la navigazione tramite tastiera
* La visualizzazione dello stato di selezione in modo chiaro e intuitivo

## VARIANTI
Sono disponibili le seguenti varianti del componente Checkbox:

* **Default**: la variante predefinita del componente, che include tutte le funzionalità principali.
	+ Descrizione: componente Checkbox di base, senza personalizzazioni.
	+ Casi d'uso: da utilizzare quando si desidera un componente di input semplice e intuitivo per gli utenti.
* **Test della descrizione del checkbox**: una variante del componente che include una descrizione dettagliata.
	+ Descrizione: il componente Checkbox con una descrizione dettagliata che fornisce informazioni aggiuntive sull'opzione selezionata.
	+ Casi d'uso: utilizzare quando si desidera fornire agli utenti ulteriori informazioni sulla scelta.

## BEST PRACTICES
Le raccomandazioni d'uso per il componente Checkbox sono:

* Utilizzare il componente in contesti dove è necessario selezionare una o più opzioni da un elenco.
* Personalizzare l'aspetto e il comportamento del componente tramite proprietà e attributi per adattarlo alle esigenze specifiche dell'applicazione.

Le linee guida implementative sono:

* Utilizzare HTML, CSS e JavaScript per la sua implementazione.
* Integrare il componente con altre librerie e framework per garantire la coerenza e la compatibilità.

Le pratiche da evitare sono:

* Non utilizzare il componente in contesti dove non è necessario selezionare opzioni (ad esempio, in un form di ricerca).

## COMPONENTI CORRELATI
Il componente Checkbox è associato ai seguenti componenti:

* **Radio Button**: un componente di input che consente all'utente di selezionare una sola opzione da un elenco.
* **Select**: un componente di input che consente all'utente di selezionare una o più opzioni da un elenco.

## OVERVIEW
<div class="table-responsive">`import { CheckboxComponent } from '@inail/intranet-webkit/form-controls';`</div>
Il componente Checkbox è progettato per fornire un modo semplice e intuitivo per creare un elenco di opzioni selezionabili all'interno di un'interfaccia utente. Ogni opzione nell'elenco rappresenta una scelta indipendente che l'utente può abilitare o disabilitare a seconda delle proprie esigenze.


## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
	<tr>
	  <th><strong>Campo</strong></th>
	  <th><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
	<tr>
	  <td><code>line</code></td>
	  <td>
		`@Input() line = false;` <br />
		Controlla il layout del componente checkbox, visualizzandolo come un elemento a block-level quando è false o inline con altri elementi quando è true.
	  </td>
	</tr>
	<tr>
	  <td><code>field-for-id</code></td>
	  <td>
		`@Input('field-for-id') fieldForId: string | undefined;` <br />
		Specifica il nome del campo per estrarre il valore per il form control.
	  </td>
	</tr>
	<tr>
	  <td><code>field-for-option</code></td>
	  <td>
		`@Input('field-for-option') fieldForOptionElement = 'descrizione';` <br />
		Il nome del campo utilizzato per l'etichetta di ciascuna opzione del checkbox.
	  </td>
	</tr>
	<tr>
	  <td><code>options</code></td>
	  <td>
		`@Input() options: CheckboxOption[];` <br />
		Rappresenta le opzioni disponibili per il gruppo di checkbox. 
	  </td>
	</tr>
	<tr>
	  <td><code>BaseInputComponent controls</code></td>
	  <td>
		`class CheckboxComponent extends BaseInputComponent` <br />
		La classe `CheckboxComponent` estende <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent</a>
	  </td>
	</tr>
	<tr>
	  <td><code>size</code></td>
	  <td>
		`@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
		La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
	  </td>
	</tr>
  </tbody>
</table>
</div>