## CARATTERISTICHE PRINCIPALI
Le caratteristiche principali del componente Form Tabellare includono:

* **Funzionalità chiave**: la possibilità di creare tabelle personalizzate e gestire i dati in modo efficiente
* **Aspetti tecnici rilevanti**: il componente è progettato per essere utilizzato in contesti web e richiede l'utilizzo di tecnologie come HTML, CSS e JavaScript
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile agli utenti con disabilità, rispettando le linee guida dell'accessibilità web

## VARIANTI
Le varianti disponibili del componente Form Tabellare includono:

* **Form Tabellare Story**: una variante che consente di creare tabelle con dati di esempio
* **N.D.**

Per ogni variante, i casi d'uso specifici includono:

* Creazione di tabelle per la gestione dei dati in contesti diversi (ad esempio, gestione degli ordini, gestione delle fatture)
* Utilizzo del componente come parte di un'applicazione web più ampia

## BEST PRACTICES
Le raccomandazioni d'uso per il componente Form Tabellare includono:

* **Raccomandazioni d'uso**: utilizzare il componente in contesti dove è necessaria la gestione dei dati in formato tabellare
* **Linee guida implementative**: rispettare le linee guida dell'accessibilità web e utilizzare tecnologie come HTML, CSS e JavaScript per garantire la compatibilità con i diversi browser
* **Pratiche da evitare**: non utilizzare il componente in contesti dove non è necessaria la gestione dei dati in formato tabellare

## COMPONENTI CORRELATI
I componenti associati al Form Tabellare includono:

* **N.D.**

Le relazioni con altri elementi includono:

* Utilizzo del componente come parte di un'applicazione web più ampia
* Integrazione con altri componenti per la gestione dei dati


## OVERVIEW
<div class="table-responsive">`import {FormTabellareComponent} from '@inail/internet-webkit/form-tabellare';`</div>

Il componente FormTabellarePageComponent gestisce una struttura di moduli dinamici con tabelle configurabili, utilizzando righe, colonne e campi di input personalizzati definiti tramite la configurazione. Include funzionalità come il reset e la conferma dei dati, e consente la visualizzazione dei risultati in una tabella e in un modale.


## API
<div class="table-responsive">
  <table class="table">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>config</code></td>
         <td>
            `@Input() config: FormTabellareConfig = new FormTabellareConfig();` <br />
            Configurazione che definisce la struttura e il comportamento del form tabellare, includendo titolo, righe, intestazioni delle colonne e campi di input. <br />
            Tipo di oggetto <a href = "?path=/docs/resources-models-formtabellareconfig--docs">FormTabellareConfig</a>
         </td>
      </tr>
      <tr>
         <td><code>formArray</code></td>
         <td>
            `@Input() formArray!: FormArray;` <br />
           Rappresenta l'array di controlli del modulo dinamico, contenente i controlli per ogni riga e colonna definiti nella configurazione.
         </td>
      </tr>
   </tbody>
</table>
</div>