## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del Button Componente includono:

* `id`: un identificatore univoco per il pulsante
* `title`: il testo da visualizzare sul pulsante
* `icon`: l'icona da visualizzare a sinistra o a destra del testo
* `isLink`: una proprietà booleana che indica se il pulsante deve avere lo stile di un link
* `size`: la dimensione del pulsante (md, sm, lg)
* `color`: il colore del pulsante (primary, secondary, success, danger, warning, info, light, dark)
* `ext-class`: una classe CSS aggiuntiva per personalizzare lo stile del pulsante
* `disabled`: una proprietà booleana che indica se il pulsante deve essere disabilitato

Gli aspetti tecnici rilevanti includono:

* L'utilizzo di Angular per la creazione del componente
* La gestione degli eventi di clic e delle azioni associate tramite l'emissione di eventi personalizzati

Le caratteristiche di accessibilità includono:

* La possibilità di aggiungere un attributo `aria-label` per fornire una descrizione testuale del pulsante
* La possibilità di aggiungere un attributo `aria-description` per fornire una descrizione dettagliata del pulsante

## VARIANTI
Le varianti disponibili per il Button Componente includono:

* Una variante con testo e icona a sinistra
* Una variante con testo e icona a destra
* Una variante con solo testo
* Una variante con solo icona

Casi d'uso specifici per ogni variante includono:

* La variante con testo e icona a sinistra può essere utilizzata per creare un pulsante di azione principale
* La variante con testo e icona a destra può essere utilizzata per creare un pulsante di azione secondaria
* La variante con solo testo può essere utilizzata per creare un pulsante di navigazione
* La variante con solo icona può essere utilizzata per creare un pulsante di azione rapida

## BEST PRACTICES
Le raccomandazioni d'uso per il Button Componente includono:

* Utilizzare il componente per creare pulsanti con diverse funzionalità e stili
* Personalizzare lo stile del pulsante utilizzando le proprietà `size`, `color` e `ext-class`
* Gestire gli eventi di clic e delle azioni associate tramite l'emissione di eventi personalizzati

Le linee guida implementative includono:

* Utilizzare Angular per la creazione del componente
* Seguire le best practice per la progettazione dell'interfaccia utente

Le pratiche da evitare includono:

* Non utilizzare il componente per creare pulsanti con funzionalità non personalizzabili
* Non utilizzare proprietà non standard per personalizzare lo stile del pulsante

## COMPONENTI CORRELATI
Il Button Componente può essere utilizzato in combinazione con altri componenti Angular per creare interfacce utente complesse. Alcuni esempi di componenti correlati includono:

* Il `Form` componente per la creazione di moduli di input
* Il `Table` componente per la visualizzazione di dati tabellari

Le relazioni con altri elementi includono:

* La possibilità di utilizzare il Button Componente come elemento di azione principale in un modulo di input
* La possibilità di utilizzare il Button Componente come elemento di navigazione in una pagina web.

## OVERVIEW
<div class="table-responsive">`import { ButtonComponent } from '@inail/internet-webkit/buttons';`</div>

Il ButtonComponent è un componente versatile per la creazione di pulsanti personalizzati e interattivi in un'interfaccia utente. Consente di definire icone, etichette, colori, dimensioni, tooltip, classi CSS aggiuntive e di configurare il comportamento del pulsante tramite eventi e proprietà.

Questo componente è progettato per essere altamente configurabile e si adatta a vari contesti, offrendo funzionalità per pulsanti semplici, collegamenti (link), pulsanti con icone a destra o sinistra, e molto altro. È un'ottima soluzione per migliorare l'accessibilità e l'estetica dell'applicazione.


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Campo</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>extId</code></td>
      <td> <code>@Input('ext-id') extId: string = composeUniqueId();</code><br /> Identificativo esterno univoco generato automaticamente. Può essere personalizzato. </td>
    </tr>
    <tr>
      <td><code>title</code></td>
      <td><code>_title = 'INSERT TITLE PROPERTY';</code><br /> <code>@Input() set title(title: string) {...}</code><br /> Titolo del pulsante. Viene utilizzato per generare un ID univoco sostituendo gli spazi con underscore.<br /> Valore di default: <code>'INSERT TITLE PROPERTY'</code>. </td>
    </tr>
    <tr>
      <td><code>id</code></td>
      <td> <code>@Input() id!: string;</code><br /> Identificativo personalizzato del pulsante. Può essere sovrascritto per fornire un valore specifico. </td>
    </tr>
    <tr>
      <td><code>icon</code></td>
      <td> <code>@Input() icon!: string | string[];</code><br /> Icona da visualizzare nel pulsante. Supporta stringhe o array di stringhe per configurazioni avanzate. </td>
    </tr>
    <tr>
      <td><code>iconRight</code></td>
      <td> <code>@Input('icon-right') iconRight!: string;</code><br /> Icona visualizzata sul lato destro del pulsante. </td>
    </tr>
    <tr>
      <td><code>isLink</code></td>
      <td> <code>@Input() isLink = false;</code><br /> Booleano che determina se il pulsante si comporta come un collegamento (link).<br /> Valore predefinito: <code>false</code>. </td>
    </tr>
    <tr>
      <td><code>sizeButton</code></td>
      <td> <code>@Input('size') sizeButton = 'md';</code><br /> Dimensione del pulsante. Valori supportati: <code>'sm'</code>, <code>'md'</code>, <code>'lg'</code>.<br /> Valore predefinito: <code>'md'</code>. </td>
    </tr>
    <tr>
      <td><code>colorButton</code></td>
      <td> <code>@Input('color') colorButton = 'primary';</code><br /> Colore del pulsante. Valori supportati: <code>'primary'</code>, <code>'secondary'</code>, <code>'danger'</code>, ecc.<br /> Valore predefinito: <code>'primary'</code>. </td>
    </tr>
    <tr>
      <td><code>extClass</code></td>
      <td> <code>@Input('ext-class') extClass = '';</code><br /> Classe CSS aggiuntiva per personalizzare lo stile del pulsante. </td>
    </tr>
    <tr>
      <td><code>disabledButton</code></td>
      <td> <code>@Input('disabled') disabledButton!: boolean;</code><br /> Booleano che abilita o disabilita il pulsante: se impostato su <code>true</code>, il pulsante è disattivato. </td>
    </tr>
    <tr>
      <td><code>hideLabel</code></td>
      <td> <code>@Input() hideLabel = false;</code><br />Booleano che determina se l'etichetta del pulsante viene nascosta.<br /> Valore predefinito: <code>false</code>. </td>
    </tr>
    <tr>
      <td><code>buttonType</code></td>
      <td> <code>@Input() buttonType = 'button';</code><br /> Tipo di pulsante HTML. Valori supportati: <code>'button'</code>, <code>'submit'</code>, <code>'reset'</code>.<br /> Valore predefinito: <code>'button'</code>. </td>
    </tr>
    <tr>
      <td><code>description</code></td>
      <td> <code>@Input() description: string | null = null;</code><br /> Descrizione opzionale per il pulsante, utile per tooltip o accessibilità. </td>
    </tr>
    <tr>
      <td><code>label</code></td>
      <td> <code>@Input() label: string | null = null;</code><br /> Etichetta del pulsante visualizzata accanto all'icona. </td>
    </tr>
  </tbody>
</table>
</div>

<br />
<br />
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Event</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
  <tr>
      <td><code>onClick</code></td>
      <td> <code>@Output() onClick: EventEmitter&lt;Event&gt;;</code><br /> Evento emesso quando il pulsante viene cliccato. </td>
    </tr>
    <tr>
      <td><code>click</code></td>
      <td> <code>@Output() click: EventEmitter&lt;Event&gt; = new EventEmitter();</code><br /> Evento emesso al clic sul pulsante. Sinonimo di <code>onClick</code>. </td>
    </tr>
 </tbody>
 </table>
</div>