## CARATTERISTICHE PRINCIPALI
Il componente Campo di Ricerca presenta le seguenti caratteristiche principali:

* Funzionalità chiave: la ricerca testuale
* Aspetti tecnici rilevanti: il componente utilizza un algoritmo di ricerca per trovare i risultati corrispondenti alla query inserita dall'utente
* Caratteristiche di accessibilità: il componente è progettato per essere accessibile anche agli utenti con disabilità, grazie all'utilizzo di attributi ARIA e di una struttura HTML semantica

## VARIANTI
Il componente Campo di Ricerca presenta le seguenti varianti:

* **Campo di ricerca disabilitato**: questa variante del componente è utilizzata quando la funzionalità di ricerca non è disponibile.
 + Caso d'uso: il campo di ricerca può essere disabilitato in determinate situazioni, ad esempio quando l'applicazione è in modalità offline o quando i dati di ricerca non sono disponibili.
* **Campo di ricerca con tasto di info**: questa variante del componente include un tasto di informazione che fornisce ulteriori dettagli sulla funzionalità di ricerca.
 + Caso d'uso: il campo di ricerca con tasto di info può essere utilizzato per fornire agli utenti ulteriori informazioni sulla funzionalità di ricerca, ad esempio sulle modalità di utilizzo o sui criteri di ricerca.

## BEST PRACTICES
Per utilizzare il componente Campo di Ricerca in modo efficace, si raccomanda:

* Utilizzare un linguaggio chiaro e conciso per la didascalia del campo di ricerca
* Fornire ulteriori informazioni sulla funzionalità di ricerca attraverso l'utilizzo di tooltip o di messaggi di aiuto
* Evitare di utilizzare il componente Campo di Ricerca in situazioni in cui la funzionalità di ricerca non è disponibile

## COMPONENTI CORRELATI
Il componente Campo di Ricerca può essere utilizzato in combinazione con altri componenti, come ad esempio:

* Componente Lista: per visualizzare i risultati della ricerca
* Componente Paginazione: per gestire la navigazione tra le pagine dei risultati della ricerca

N.D.

## ACCESSIBILITA'
La label deve essere associata all’input tramite l’attributo `for`.
Qualora label e input non siano direttamente collegati nel DOM (es. separati da contenitori), utilizzare `aria-labelledby` (valorizzato con l’ID del contenitore della label) per garantire la corretta associazione per le tecnologie assistive.
Esempio:
`<label id="x">
<input aria-labelledby="x"></input>
</label>`
`