## CARATTERISTICHE PRINCIPALI

*   Funzionalità chiave:
    *   Animazione di caricamento personalizzabile
    *   Possibilità di impostare il colore e lo stile dell'animazione
*   Aspetti tecnici rilevanti:
    *   Utilizza la tecnologia CSS per creare l'animazione di caricamento
*   Caratteristiche di accessibilità:
    *   Il componente è progettato per essere accessibile, aiutando gli utenti con disabilità a comprendere lo stato di caricamento dei dati.

## VARIANTI
Il Content Loader ha diverse varianti che possono essere utilizzate in diversi contesti:

*   **Test della descrizione del content-loader INAIL**: questa variante è progettata specificamente per l'utilizzo nel contesto INAIL e include un testo descrittivo personalizzato.
*   **Caricamento in corso**: Questa variante visualizza un messaggio di caricamento generico che può essere utilizzato in diversi contesti.

## BEST PRACTICES

*   Raccomandazioni d'uso:
    *   Utilizzare il Content Loader per migliorare l'esperienza utente durante il caricamento dei dati
    *   Personalizzare l'animazione di caricamento per adattarsi al proprio marchio o stile
*   Linee guida implementative:
    *   Utilizzare la tecnologia CSS per creare l'animazione di caricamento
    *   Assicurarsi che il componente sia accessibile e conforme agli standard web
*   Pratiche da evitare:
    *   Non utilizzare il Content Loader come unico mezzo per comunicare lo stato del sistema

## COMPONENTI CORRELATI

*   Componenti associati: N.D.
*   Relazioni con altri elementi: Il Content Loader può essere utilizzato in combinazione con altri componenti per creare un'esperienza utente più completa e professionale.

## OVERVIEW
<div class="table-responsive">`import { ContentLoaderComponent } from '@inail/intranet-webkit/utils';`</div>


Il ContentLoaderComponent è un componente progettato per gestire in modo efficace il caricamento di contenuti dinamici all'interno di un'interfaccia utente.

Questo componente è particolarmente utile per migliorare l'esperienza utente durante l'attesa del caricamento di dati o contenuti da una fonte esterna. Può essere configurato per visualizzare animazioni di caricamento personalizzate, fornendo un feedback visivo che comunica chiaramente che il contenuto è in fase di caricamento.


## API
<div class="table-responsive">
  <table class="table table-documentation">
	<thead> 
		<tr> 
			<th><strong>Campo</strong></th> 
			<th><strong>Descrizione</strong></th> 
		</tr> 
	</thead> 
	<tbody> 
		<tr> 
		   <td><code>loading</code></td> 
		   <td> `private _loading = false;`<br />
		   		`@Input()`<br />
				`@HostBinding('class.loading')`<br />
				`set loading(val: boolean) {}` <br /> 
				Questo input booleano controlla la visualizzazione dell'animazione di caricamento.<br />  
				<ul>
				<li>Quando è impostato su <code>true</code>, viene mostrato un cerchio di caricamento.</li>
				<li>Quando è impostato su <code>false</code>, il caricamento è disattivato (valore predefinito).</li>
				</ul>
				Utilizzando il decoratore <code>@HostBinding</code>, viene assegnata automaticamente la classe CSS <code>loading</code> agli elementi del DOM per abilitare la visualizzazione dell'animazione. </td> 
		</tr> 
		<tr> 
			<td><code>size</code></td> 
			<td> `@Input() size: 'small' | 'normal' | 'big' = 'normal';` <br /> Specifica la dimensione del caricamento: <code>small</code>, <code>normal</code> o <code>big</code>. Il valore predefinito è <code>normal</code>. </td> 
		</tr> 
		<tr> 
			<td><code>spinnerMessage</code>
			</td> 
			<td> `@Input() spinnerMessage = 'MESSAGES.SPINNER_LOADING';` <br /> Definisce il messaggio visualizzato durante il caricamento. Il valore predefinito è <code>'Caricamento in corso'</code>. <br /><code>Questo testo viene utilizzato per garantire l'accessibilità e il supporto ai lettori di schermo.</code>
			</td> 
		</tr> 
		<tr> 
			<td><code>spinnerMessageEnd</code>
			</td> 
			<td> `@Input() spinnerMessageEnd = 'MESSAGES.SPINNER_LOADING_END';` <br /> Definisce il messaggio visualizzato al termine del caricamento. Il valore predefinito è <code>'Caricamento terminato'</code>. <br /><code>Questo testo viene utilizzato per garantire l'accessibilità e il supporto ai lettori di schermo.</code>
			</td> 
		</tr> 
	</tbody> 
</table>
</div>