## CARATTERISTICHE PRINCIPALI

Il componente Textarea presenta le seguenti caratteristiche chiave:

* Funzionalità di input testuale: il componente consente agli utenti di inserire del testo in una zona di testo più grande
* Gestione dei dati immessi dall'utente: il componente gestisce i dati immessi dall'utente e li rende disponibili per ulteriori elaborazioni

Gli aspetti tecnici rilevanti includono:

* La gestione degli eventi di input testuale
* La gestione della dimensione del testo inserito

Le caratteristiche di accessibilità includono:

* La possibilità di utilizzare la tastiera per navigare e selezionare il testo
* La compatibilità con le tecnologie assistive per gli utenti con disabilità visive

## VARIANTI

Il componente Textarea presenta le seguenti varianti:

### Variante 1: Textarea disabilitata

Questa variante del componente Textarea è disabilitata e non consente agli utenti di inserire testo.

### Variante 2: Textarea con errore

Questa variante del componente Textarea visualizza un messaggio di errore quando l'utente inserisce del testo non valido.

### Variante 3: Textarea con tasto di info

Questa variante del componente Textarea include un tasto di informazione che fornisce ulteriori dettagli sull'utilizzo del componente.

## BEST PRACTICES

Per utilizzare il componente Textarea in modo efficace, si consiglia:

* Di utilizzare il componente per raccogliere informazioni testuali dagli utenti
* Di gestire i dati immessi dall'utente in modo sicuro e coerente
* Di fornire feedback agli utenti quando inseriscono del testo non valido

Si sconsiglia di:

* Utilizzare il componente per raccogliere informazioni sensibili dagli utenti
* Non gestire i dati immessi dall'utente in modo sicuro e coerente

## COMPONENTI CORRELATI

Il componente Textarea è correlato ai seguenti componenti:

* Campo di testo: un componente di input testuale più piccolo rispetto al Textarea
* Area di testo: un componente di input testuale più grande rispetto al Textarea

Le relazioni con altri elementi includono:

* La gestione degli eventi di input testuale tra il componente Textarea e gli altri componenti della pagina.

## ACCESSIBILITA'
La label deve essere associata all’input tramite l’attributo `for`.
Qualora label e input non siano direttamente collegati nel DOM (es. separati da contenitori), utilizzare `aria-labelledby` (valorizzato con l’ID del contenitore della label) per garantire la corretta associazione per le tecnologie assistive.

Esempio:
`<label id="x">
<input aria-labelledby="x"></input>
</label>`
`
