## CARATTERISTICHE PRINCIPALI
Il componente Skip Link INAIL presenta le seguenti caratteristiche principali:

* Funzionalità chiave: il componente consente agli utenti di saltare le sezioni non essenziali della pagina
* Aspetti tecnici rilevanti: il componente utilizza la tecnologia HTML e CSS per funzionare correttamente
* Caratteristiche di accessibilità: il componente è progettato per migliorare l'accessibilità delle pagine web per gli utenti con disabilità

## VARIANTI
Il componente Skip Link INAIL presenta le seguenti varianti:

* Variante 1: skip link standard
 + Caso d'uso: utilizzato in pagine web con contenuto statico
 + Descrizione breve: il componente visualizza un link di salto per consentire agli utenti di saltare le sezioni non essenziali della pagina
* Variante 2: skip link personalizzabile
 + Caso d'uso: utilizzato in pagine web con contenuto dinamico
 + Descrizione breve: il componente consente di personalizzare l'aspetto e il comportamento del link di salto

## BEST PRACTICES
Per utilizzare correttamente il componente Skip Link INAIL, si raccomanda:

* Utilizzare il componente in pagine web con contenuto statico o dinamico
* Personalizzare l'aspetto e il comportamento del link di salto per adattarlo alle esigenze specifiche della pagina web
* Evitare di utilizzare il componente in pagine web con contenuto troppo complesso o disordinato

## COMPONENTI CORRELATI
Il componente Skip Link INAIL è correlato ai seguenti componenti:

* Componente di navigazione principale
* Componente di footer
* Componente di sidebar

Nota: N.D. indica che non ci sono informazioni disponibili per una determinata sezione.

## OVERVIEW
<div class="table-responsive">`import { SkipLinkComponent } from '@inail/intranet-webkit/page-sections';`</div>

Il componente `SkipLinkComponent` offre agli utenti la possibilità di raggiungere rapidamente il contenuto principale della pagina, evitando elementi ricorrenti come la testata e il menu principale. Questo facilita la navigazione, in particolare per coloro che utilizzano tecnologie assistive, come gli screen reader, consentendo un accesso immediato alle informazioni essenziali.

## API
Questo componente non è visibile nei layout.