## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave:
 + Supporto a più valute
 + Formattazione automatica degli importi
 + Convalida dell'input
* Aspetti tecnici rilevanti:
 + Utilizza un algoritmo di formattazione avanzato per gestire le diverse valute
 + Supporta la convalida dell'input tramite espressioni regolari
* Caratteristiche di accessibilità:
 + Il componente è progettato per essere accessibile da tastiera e da screen reader

## VARIANTI

Il componente Input Currency ha due varianti principali:

### Variante 1: Default

Questa variante rappresenta il comportamento predefinito del componente. Fornisce un campo di input standard con supporto a più valute.

* Caso d'uso: Utilizzare questa variante quando si desidera un campo di input standard per la gestione delle valute.
* Descrizione breve: Campo di input standard per la gestione delle valute.

### Variante 2: INAIL

Questa variante rappresenta una versione personalizzata del componente per l'utilizzo con l'INAIL. Fornisce un campo di input con supporto a più valute e una formattazione specifica per l'INAIL.

* Caso d'uso: Utilizzare questa variante quando si desidera un campo di input personalizzato per la gestione delle valute con l'INAIL.
* Descrizione breve: Campo di input personalizzato per la gestione delle valute con l'INAIL.

## BEST PRACTICES

* Raccomandazioni d'uso:
 + Utilizzare il componente Input Currency quando si desidera un campo di input standard o personalizzato per la gestione delle valute.
 + Configurare il componente in base alle esigenze specifiche dell'applicazione.
* Linee guida implementative:
 + Utilizzare il componente come parte di un form più ampio per la gestione delle valute.
 + Utilizzare le proprietà del componente per personalizzare il comportamento e l'aspetto del campo di input.
* Pratiche da evitare:
 + Non utilizzare il componente Input Currency quando si desidera un campo di input standard senza supporto a più valute.

## COMPONENTI CORRELATI

Il componente Input Currency è associato ai seguenti componenti:

* Campo di input standard
* Forma per la gestione delle valute

Le relazioni con altri elementi sono:

* Il componente Input Currency può essere utilizzato in combinazione con il componente di selezione della valuta per fornire un'interfaccia completa per l'inserimento di valori monetari.

## OVERVIEW
<div class="table-responsive">`import { InputCurrencyComponent } from '@inail/intranet-webkit/form-controls';`</div>
Questo componente rappresenta un campo di input per l'inserimento di valori in formato valuta, con supporto per personalizzare il suffisso, il numero di decimali e altre opzioni di configurazione. È progettato per l'uso in moduli, con funzionalità come la convalida dei dati, la visualizzazione di messaggi di errore e il supporto per tooltip e personalizzazioni dell'aspetto.

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>suffix</code></td>
      <td>
        `@Input() suffix = '€';` <br />
       Un suffisso personalizzabile da aggiungere al valore inserito nel campo di input della valuta.
      </td>
    </tr>
    <tr>
      <td><code>fractionSize</code></td>
      <td>
        `@Input() fractionSize = 2;` <br />
        Specifica il numero di cifre decimali visualizzate per la valuta.
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class InputCurrencyComponent extends BaseInputComponent` <br />
       La classe InputCurrencyComponent estende <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent</a>
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
      `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
      La proprietà `size`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a>, nella classe `BasePageSection`,  rappresenta la configurazione delle colonne nel sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, sfruttando i principi di progettazione responsiva di Bootstrap.
      </td>
    </tr>
  </tbody>
</table>
</div>