# BaseInputComponent

Documentazione dettagliata della classe custom  **BaseInputComponent**, usata nei componenti <a href="?path=/story/components-form-form-controls-checkbox--checkbox">Form Controls</a> di Internet Webkit v17. Questi componenti estendono il **BaseInputComponent** per ereditare attributi aggiuntivi dalla classe.
<br />
<div class="table-responsive">`class CheckboxComponent extends BaseInputComponent`</div>
<br />
<br />

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>labelSrOnly</code></td>
      <td>Specifica se l'etichetta deve essere visibile solo per gli screen reader (quindi non visibile). </td>
    </tr>
    <tr>
      <td><code>label</code></td>
      <td>Identificativo del campo. Viene utilizzato anche per la traduzione (i18n). Se ci sono più campi con la stessa chiave i18n, per garantire l'unicità dell'ID, è necessario impostare anche un ID esterno (ext-id).</td>
    </tr>
    <tr>
      <td><code>id</code></td>
      <td>Identificativo del campo. Viene utilizzato anche per la traduzione (i18n).</td>
    </tr>
    <tr>
      <td><code>extId</code></td>
      <td>In caso di più campi con la stessa chiave i18n, consente di distinguere i vari casi.</td>
    </tr>
    <tr>
      <td><code>placeholder</code></td>
      <td>Il testo di suggerimento che appare nel campo di input quando non è presente alcun valore.</td>
    </tr>
    <tr>
      <td><code>formControl</code></td>
      <td>Il controllo del modulo associato al campo di input.</td>
    </tr>
    <tr>
      <td><code>readonlyValue</code></td>
      <td>Il valore che deve essere mostrato nel campo, ma che non può essere modificato.</td>
    </tr>
    <tr>
      <td><code>sizeLabel</code></td>
      <td>Definisce la dimensione del label del campo, basata sul sistema di grid di Bootstrap.</td>
    </tr>
    <tr>
      <td><code>sizeMessages</code></td>
      <td>Definisce la dimensione dei messaggi di errore o avviso sotto il campo di input, basata sul sistema di grid di Bootstrap.</td>
    </tr>
    <tr>
      <td><code>sizeInput</code></td>
      <td>Definisce la dimensione del campo di input, basata sul sistema di grid di Bootstrap.</td>
    </tr>
    <tr>
      <td><code>errorsLabel</code></td>
      <td>Le etichette di errore da visualizzare accanto al campo di input, nel caso di errori di validazione.</td>
    </tr>
    <tr>
      <td><code>tooltip</code></td>
      <td>Il testo del tooltip che appare come suggerimento quando l'utente interagisce con il campo di input.</td>
    </tr>
    <tr>
      <td><code>disabled</code></td>
      <td>Indica se il campo è disabilitato e non può essere modificato dall'utente.</td>
    </tr>
    <tr>
      <td><code>readonly</code></td>
      <td>Indica se il campo è in modalità sola lettura, quindi non può essere modificato, ma può essere visualizzato.</td>
    </tr>
    <tr>
      <td><code>actions</code></td>
      <td>Azioni visualizzate sulla destra del campo di input. Sono rappresentate come un array di oggetti <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>.</td>
    </tr>
    <tr>
      <td><code>warningMessage</code></td>
      <td>Un messaggio di avviso che viene sempre visualizzato sotto il campo di input.</td>
    </tr>
    <tr>
      <td><code>required</code></td>
      <td>Indica se il campo è obbligatorio e deve essere compilato prima di inviare il modulo.</td>
    </tr>
    <tr>
      <td><code>error</code></td>
      <td>Contiene gli errori di validazione generati da questo componente.</td>
    </tr>
    <tr>
      <td><code>value</code></td>
      <td>Il valore del campo di input.</td>
    </tr>
    <tr>
      <td><code>supportMessage</code></td>
      <td>Un messaggio di supporto che appare sotto il campo di input.</td>
    </tr>
    <tr>
      <td><code>removeMessagesSpace</code></td>
      <td>Indica se lo spazio per i messaggi di errore o avviso deve essere rimosso dal layout.</td>
    </tr>
    <tr>
      <td><code>asteriskReplacedToSR</code></td>
      <td>Parametro che sostituisce l'asterisco con l'etichetta ERROR.REQUIRED per i campi obbligatori, visibile solo per gli screen reader.</td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-form-form-controls-checkbox--checkbox">Form Controls</a>
