import{a as r}from"./Utilities-CQhZFhp5.js";const l="",s=`**PANORAMICA**  
- **Descrizione generale**: Il componente Button rappresenta un elemento interattivo che consente agli utenti di eseguire azioni o triggerare eventi all'interno di un'interfaccia web.
- **Funzionalità principali**: Offre un'ampia gamma di varianti stilistiche e dimensioni per adattarsi a diversi contesti d'uso, garantendo coerenza e accessibilità.

**CASO D'USO**  
- **Scenari di utilizzo principali**: Utilizzato per inviare moduli, avviare processi, navigare tra pagine o eseguire qualsiasi azione definita dall'applicazione.
- **Contesto di implementazione consigliato**: Ideale in qualsiasi punto dell'interfaccia dove è richiesta un'interazione utente per eseguire un'azione specifica.
- **Posizionamento ideale nell'interfaccia**: Può essere posizionato in moduli, toolbar, dialoghi o come call-to-action prominente nelle pagine.

**CARATTERISTICHE PRINCIPALI**  
- **Funzionalità chiave**:
  - Supporto per varianti di stile: primario, secondario, successo, pericolo, avviso, informazione, luce, scuro.
  - Dimensioni personalizzabili: piccolo, medio, grande.
  - Stato disabilitato per indicare azioni non disponibili.
- **Aspetti tecnici rilevanti**: Implementato utilizzando l'elemento \`<button>\` o \`<a>\` con ruoli e attributi appropriati per garantire l'accessibilità.
- **Caratteristiche di accessibilità**: Progettato per essere completamente navigabile tramite tastiera e compatibile con screen reader, includendo attributi ARIA quando necessario.

**VARIANTI**  
- **Elenco e descrizione delle varianti disponibili**:
  - Stili: primario, secondario, successo, pericolo, avviso, informazione, luce, scuro.
  - Dimensioni: piccolo, medio, grande.
- **Casi d'uso specifici per ogni variante**:
  - Stili diversi per indicare l'importanza o la natura dell'azione.
  - Dimensioni diverse per adattarsi a spazi specifici nell'interfaccia.

**PROPRIETÀ**  
- **Proprietà configurabili**:
  - \`type\`: specifica il tipo di pulsante (\`button\`, \`submit\`, \`reset\`).
  - \`disabled\`: disabilita l'interazione con il pulsante.
  - \`aria-label\`: fornisce un'etichetta accessibile per il pulsante.
- **Parametri disponibili**: Possibilità di aggiungere attributi personalizzati per estendere la funzionalità.
- **Attributi per l'accessibilità**: Utilizzo di \`aria-label\` o \`aria-labelledby\` per descrivere l'azione del pulsante.

**DETTAGLI DI IMPLEMENTAZIONE**  
- **Struttura HTML**: Il pulsante è rappresentato da un elemento \`<button>\` o \`<a>\` con classi specifiche per lo stile e attributi per l'accessibilità.
- **Stile e CSS utilizzati**: Utilizza classi CSS per gestire il layout e l'aspetto, garantendo coerenza con il design system.
- **Variabili CSS disponibili e loro funzione**:
  - \`--btn-padding\`: padding interno del pulsante.
  - \`--btn-font-size\`: dimensione del testo del pulsante.
  - \`--btn-border-radius\`: raggio dei bordi del pulsante.
  - \`--btn-background-color\`: colore di sfondo del pulsante.
  - \`--btn-text-color\`: colore del testo del pulsante.

**BEST PRACTICES**  
- **Raccomandazioni d'uso**:
  - Utilizzare etichette chiare e concise che descrivano l'azione del pulsante.
  - Assicurarsi che il pulsante sia facilmente identificabile e distinguibile dagli altri elementi.
- **Linee guida implementative**: Evitare di utilizzare pulsanti per navigare tra pagine; preferire link per la navigazione.
- **Pratiche da evitare**: Evitare di utilizzare pulsanti senza etichette o con etichette ambigue.

**LINEE GUIDA PER L'ACCESSIBILITÀ**  
- **Requisiti di accessibilità**: Assicurarsi che il pulsante sia navigabile tramite tastiera e che abbia un'etichetta descrittiva.
- **Supporto tastiera**: Il pulsante deve essere attivabile tramite la barra spaziatrice o Invio.
- **Configurazione screen reader**: Utilizzare attributi ARIA per fornire informazioni sul contesto e la funzione del pulsante.

**COMPONENTI CORRELATI**  
- **Componenti associati**: Button Group, Toolbar, Icon Button.
- **Relazioni con altri elementi**: Spesso utilizzato all'interno di moduli, dialoghi o come call-to-action nelle pagine.
`,c=i=>i.map(e=>`<li><button type="button" class="bg-transparent border-0 dropdown-item"><i class="text-primary fas ${e.icon}"></i> ${e.label}</button></li>`).join(`
`);function d(i,e){return`<div class="d-flex align-items-center">
    <div class="dropdown">
        <button type="button"
            class="bg-transparent border-0 dropdown-toggle p-0 mt-5 inail-ac"
            data-toggle="tooltip"
            data-placement="top"
            data-original-title="${i}"
            aria-haspopup="true"
            aria-label="${i}"
            id="dropdownButton">
            <i class="text-primary fas fa-ellipsis"></i>
        </button>
        <ul class="dropdown-menu inail-action-dropdown">
            ${c(e)}
        </ul>
    </div>
</div>`}const u={title:"Componenti/Menu/Actions Dropdown",tags:["autodocs"],argTypes:{tooltip:{control:"text",description:"Tooltip del dropdown."},actions:{control:"object",description:"Elenco di azioni disponibili."}},args:{tooltip:"Altre azioni",actions:[{icon:"fa-download",label:"Scarica"},{icon:"fa-print",label:"Stampa"}]},render:i=>d(i.tooltip,i.actions),parameters:{docs:{description:{component:s},mdxPage:l}},decorators:[(i,e)=>r(i,e,1,["https://cdn.inailcloud.it/assets/inail/u.1.0/static-webkit/js/custom-webkit.js","https://cdn.inailcloud.it/assets/inail/u.1.0/static-webkit/js/custom-action-dropdown.js"],!0),i=>`<main id="contenutoPrincipale">${i()}</main>`]},n={name:"Actions Dropdown"};var t,a,o;n.parameters={...n.parameters,docs:{...(t=n.parameters)==null?void 0:t.docs,source:{originalSource:`{
  name: "Actions Dropdown"
}`,...(o=(a=n.parameters)==null?void 0:a.docs)==null?void 0:o.source}}};const m=["DropdownDefault"];export{n as DropdownDefault,m as __namedExportsOrder,u as default};
