# FilterText

Documentazione dettagliata della classe custom **FilterText**, usata nei componenti di Intranet Webkit v17. 
**FilterText** viene utilizzato per creare filtri di ricerca semplici o avanzati.

## Implementazione
<div class="table-responsive">`import { SearchFilterComponent } from '@inail/intranet-webkit/search-filter';`</div>
<br />

***Struttura:***
`	constructor(labelId: string,
  dtoField: string,
  size?: string,
  tooltip?: any,
  validators?: any,
  errmessageLabel?: ErrorLabel[],
  advancedFilter: boolean)`

***Esempio d'uso:***
<br />
`filter = new FilterText('Advanced Filter', 'email', '12|4|4', '', '', undefined, true)`

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>labelId</code></td>
      <td>
        Campo tipo string che assegna un id al filtro.
      </td>
    </tr>
    <tr>
      <td><code>dtoField</code></td>
      <td>
        Campo tipo string che assegna al filtro il campo su cui applicare la ricerca.
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
        Campo di tipo string non obbligatorio che assegna il `BootstrapSize` al filtro spiegato nella <a href="?path=/docs/resources-models-bootstrapsize--docs">documentazione di BootstrapSize</a>.
      </td>
    </tr>
    <tr>
      <td><code>tooltip</code></td>
      <td>
        Campo non obbligatorio che si usa per assegnare un tooltip al un filtro di ricerca.
      </td>
    </tr>
    <tr>
      <td><code>validators</code></td>
      <td>
        Campo non obbligatorio tramite il quale possiamo assegnare delle regole di validazione al input di filtro ricerca, come in un Form.
      </td>
    </tr>
    <tr>
      <td><code>errMessageLabel</code></td>
      <td>
        Campo non obligatorio. Un array di <a href="?path=/docs/resources-models-errorlabel--docs">ErrorLabel</a> che si usa per impostare dei messaggi di errore nel caso in cui siano state impostate delle regole di validazione tramite `validators`.
      </td>
    </tr>
    <tr>
      <td><code>advancedFilter</code></td>
      <td>
        Campo di tipo boolean che decide se il filtro di ricerca è semplice (`false`) o avanzato (`true`). Quando è `true`, il filtro creato si mostra condizionalmente in una sezione speciale del componente <a href="?path=/story/components-searchfilter--search-filter">Search Filter</a> tramite il valore dell'input booleano `showAdvancedFilter`.
      </td>
    </tr>
    <tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-searchfilter--search-filter">Search Filter</a>