## CARATTERISTICHE PRINCIPALI
Il componente Input Messages presenta le seguenti caratteristiche chiave:

* Funzionalità di visualizzazione di messaggi: il componente può visualizzare messaggi di avviso o informazione relativi a un input dell'utente
* Personalizzazione del contenuto dei messaggi: è possibile personalizzare il contenuto dei messaggi visualizzati dal componente

Gli aspetti tecnici rilevanti del componente sono:

* Utilizzo di HTML e CSS per la definizione della struttura e dello stile del componente
* Possibilità di utilizzare JavaScript per gestire le interazioni con l'utente

Le caratteristiche di accessibilità del componente sono:

* Rispetto delle linee guida WCAG 2.1 per l'accessibilità web
* Utilizzo di attributi ARIA per migliorare l'accessibilità per gli utenti con disabilità

## VARIANTI
Il componente Input Messages presenta le seguenti varianti:

* **Input Message**: visualizza un messaggio di avviso o informazione relativo a un input dell'utente
	+ Caso d'uso: visualizzare un messaggio di errore quando l'utente inserisce un valore non valido in un campo di input
	+ Breve descrizione: il componente visualizza un messaggio di avviso o informazione relativo a un input dell'utente

## BEST PRACTICES
Le raccomandazioni d'uso per il componente Input Messages sono:

* Utilizzare il componente solo quando necessario, per evitare di sovraccaricare l'interfaccia utente
* Personalizzare il contenuto dei messaggi per renderli più pertinenti al contesto in cui vengono visualizzati

Le linee guida implementative sono:

* Utilizzare HTML e CSS per definire la struttura e lo stile del componente
* Utilizzare JavaScript per gestire le interazioni con l'utente

Le pratiche da evitare sono:

* Evita di utilizzare il componente come unica forma di feedback, perché potrebbe generare confusione o frustrazione nell'utente.

## COMPONENTI CORRELATI
Il componente Input Messages è associato ai seguenti componenti:

* **Input**: il componente Input Messages viene utilizzato per visualizzare messaggi relativi a un input dell'utente
* **Button**: il componente Input Messages può essere utilizzato in combinazione con il componente Button per fornire feedback all'utente dopo che ha cliccato su un pulsante

## OVERVIEW
<div class="table-responsive">`import { InputMessagesComponent } from '@inail/intranet-webkit/form-controls';`</div>

Il componente `InputMessagesComponent` viene utilizzato per visualizzare messaggi di errore, avvisi e supporto relativi a un campo di input. Consente di fornire un feedback chiaro e utile all'utente durante l'interazione con i moduli, migliorando l'usabilità e l'accessibilità del sistema. 

## API
<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>inailInputMessages</code></td>
         <td>
            `@Input('inailInputMessages') control: AbstractControl ;` <br />
            Il controllo del modulo a cui sono associati i messaggi di errore e di supporto.
         </td>
      </tr>
      <tr>
         <td><code>errors</code></td>
         <td>
            `@Input() errors: Array<ErrorLabel>;` <br />
            Elenco di messaggi di errore personalizzati associati al controllo del modulo.
         </td>
      </tr>
       <tr>
         <td><code>warning</code></td>
         <td>
            `@Input() warning!: string;` <br />
            Messaggio di avviso mostrato, se necessario, per guidare l'utente.
         </td>
      </tr>
       <tr>
         <td><code>support</code></td>
         <td>
            `@Input() support!: string;` <br />
            Messaggio di supporto che fornisce indicazioni aggiuntive su come compilare il campo di input.
         </td>
      </tr>
       <tr>
         <td><code>inputId</code></td>
         <td>
            `@Input() inputId!: string;` <br />
            L'ID univoco assegnato all'elemento di input per l'associazione con le etichette e i messaggi.
         </td>
      </tr>
       <tr>
         <td><code>removeMessagesSpace</code></td>
         <td>
            `@Input() removeMessagesSpace!: boolean;` <br />
            Se impostato su `true`, rimuove lo spazio riservato ai messaggi sotto il campo di input.
         </td>
      </tr>
       <tr>
         <td><code>label</code></td>
         <td>
            `@Input() label = '';` <br />
            L'etichetta associata all'input per fornire una descrizione chiara.
         </td>
      </tr>
	  <tr>
         <td><code>required</code></td>
         <td>
            `@Input() required = false;` <br />
            Indica se il campo è obbligatorio.
         </td>
      </tr>
   </tbody>
</table>
</div>