## CARATTERISTICHE PRINCIPALI

Il componente Single Checkbox presenta le seguenti caratteristiche chiave:

* Funzionalità di selezione/deselezione: il componente consente all'utente di selezionare o deselezionare un'opzione
* Aspetti tecnici rilevanti:
 + Il componente utilizza una proprietà "checked" per gestire lo stato di selezione dell'opzione
 + Il componente può essere personalizzato mediante l'utilizzo di attributi HTML
* Caratteristiche di accessibilità: il componente è progettato per essere accessibile agli utenti con disabilità, in quanto utilizza attributi ARIA per fornire informazioni sulla selezione dell'opzione

## VARIANTI

Il componente Single Checkbox presenta le seguenti varianti:

* **Test della descrizione dell'input INAIL**: questa variante include una descrizione dettagliata dell'input
* **Single Checkbox label Need help? Contact support.**: questa variante include un'etichetta con un messaggio di aiuto

Per ogni variante, i casi d'uso specifici includono:

* Utilizzare la variante "Test della descrizione dell'input INAIL" quando si desidera fornire una descrizione dettagliata dell'input
* Utilizzare la variante "Single Checkbox label Need help? Contact support." quando si desidera fornire un messaggio di aiuto all'utente

## BEST PRACTICES

Le raccomandazioni d'uso per il componente Single Checkbox includono:

* Utilizzare il componente in contesti in cui è necessaria una semplice e intuitiva modalità per gli utenti di esprimere la loro scelta
* Personalizzare il componente mediante l'utilizzo di attributi HTML per adattarlo alle esigenze specifiche dell'applicazione

Le linee guida implementative includono:

* Utilizzare la proprietà "checked" per gestire lo stato di selezione dell'opzione
* Utilizzare attributi ARIA per fornire informazioni sulla selezione dell'opzione agli utenti con disabilità

Le pratiche da evitare includono:

* Non utilizzare il componente in contesti in cui è necessaria una complessa gestione delle opzioni
* Non personalizzare eccessivamente il componente, in quanto ciò potrebbe compromettere la sua accessibilità

## COMPONENTI CORRELATI

Il componente Single Checkbox è associato ai seguenti componenti:

* Input text: il componente può essere utilizzato in combinazione con input text per fornire una modalità di selezione delle opzioni
* Button: il componente può essere utilizzato in combinazione con button per fornire una modalità di conferma della scelta

Le relazioni con altri elementi includono:

* Il componente Single Checkbox può essere utilizzato all'interno di un form per gestire le opzioni di selezione
* Il componente Single Checkbox può essere utilizzato in combinazione con altri componenti per creare una interfaccia utente complessa

## OVERVIEW
<div class="table-responsive">`import { SingleCheckboxComponent } from '@inail/intranet-webkit/form-controls';`</div>

Il componente Single Checkbox è progettato per fornire un modo semplice e intuitivo per creare un'opzione selezionabile all'interno di un'interfaccia utente. L'opzione rappresenta una scelta indipendente che l'utente può abilitare o disabilitare a seconda delle proprie esigenze.


## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>checked-value</code></td>
      <td>
        `@Input('checked-value') checkedValue: any = true;` <br />
        Specificare lo stato selezionato del checkbox.
      </td>
    </tr>
    <tr>
      <td><code>unchecked-value</code></td>
      <td>
        `@Input('unchecked-value') uncheckedValue: any = false;` <br />
        Specificare lo stato deselezionato del checkbox.
      </td>
    </tr>
    <tr>
      <td><code>line</code></td>
      <td>
        `@Input() line!: false;` <br />
        Controlla il layout del componente checkbox, visualizzandolo come un elemento block-level quando è falso o inline con altri elementi quando è vero.
      </td>
    </tr>
    <tr>
      <td><code>i18n-extra</code></td>
      <td>
        `@Input('i18n-extra') i18nExtra: any;` <br />
        Consente al componente di visualizzare testo tradotto aggiuntivo o informazioni localizzate accanto alla casella di controllo.
      </td>
    </tr>
    <tr>
      <td><code>alignInForm</code></td>
      <td>
        `@Input() alignInForm = false;` <br />
        Allinea la casella di controllo all'interno di una struttura form per adattarla al layout o allo stile generale del form.
      </td>
    </tr>
    <tr>
      <td><code>showMessages</code></td>
      <td>
        `@Input() showMessages = true;` <br />
        Situazione particolare in cui i messaggi non devono essere visualizzati.
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class SingleCheckboxComponent extends BaseInputComponent` <br />
        Fare riferimento a <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent.</a>
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
     `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
      La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
      </td>
    </tr>
  </tbody>
</table>
</div>