## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave:
 + Selezioni multiple: consente agli utenti di selezionare più opzioni da un elenco.
 + Filtraggio delle opzioni: fornisce una funzionalità di filtraggio per restringere le opzioni disponibili.
* Aspetti tecnici rilevanti:
 + Il componente utilizza una struttura dati per memorizzare le opzioni e le selezioni dell'utente.
 + Fornisce eventi personalizzabili per gestire le interazioni dell'utente.
* Caratteristiche di accessibilità:
 + Supporta la navigazione con tastiera per utenti con disabilità motorie.

## VARIANTI

* **Multiple Select Test**: una variante del componente che consente di testare la selezione multipla di opzioni.
 + Casi d'uso specifici: utilizzare il componente in un modulo di registrazione per consentire agli utenti di selezionare più interessi.
 + Breve descrizione: "Consente agli utenti di selezionare più opzioni da un elenco filtrabile".
* **Multiple Select Remote Test**: una variante del componente che consente di testare la selezione multipla di opzioni con dati remoti.
 + Casi d'uso specifici: utilizzare il componente in un'applicazione web per consentire agli utenti di selezionare più città da un elenco filtrabile.
 + Breve descrizione: "Consente agli utenti di selezionare più opzioni da un elenco filtrabile con dati remoti".

## BEST PRACTICES

* Raccomandazioni d'uso:
 + Utilizzare il componente in contesti dove è necessaria la selezione multipla di valori.
 + Fornire un feedback chiaro e immediato alle azioni dell'utente.
* Linee guida implementative:
 + Utilizzare una struttura dati coerente per memorizzare le opzioni e le selezioni dell'utente.
 + Gestire gli eventi personalizzabili per fornire un'esperienza utente fluida.
* Pratiche da evitare:
 + Evitare di utilizzare il componente in contesti dove non è necessaria la selezione multipla di valori.

## COMPONENTI CORRELATI

* Componenti associati: Campo di testo, Lista a discesa
* Relazioni con altri elementi: Il componente può essere utilizzato in combinazione con altri elementi di interfaccia utente per fornire un'esperienza utente completa.

## OVERVIEW
<div class="table-responsive">`import { MultipleSelectComponent } from '@inail/intranet-webkit/form-controls';`</div>

Il componente MultipleSelectComponent consente agli utenti di selezionare più opzioni da un elenco predefinito, con funzionalità di ricerca e filtro. Il componente permette di visualizzare un elenco di opzioni che possono essere filtrate dinamicamente tramite una ricerca live.Le opzioni per la selezione sono passate come array di oggetti e possono essere recuperate anche tramite un Observable, consentendo di gestire dati remoti in modo dinamico. Il componente offre inoltre la possibilità di aggiungere messaggi di supporto e di avviso sotto il campo di input.


## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>field-for-id</code></td>
      <td>
        `@Input('field-for-id') fieldForId!: string;` <br />
        Nome del campo utilizzato come ID univoco per ciascuna opzione.
      </td>
    </tr>
    <tr>
      <td><code>field-for-option</code></td>
      <td>
        `@Input('field-for-option') fieldForOptionElement = 'descrizione';` <br />
        Nome del campo utilizzato per visualizzare l'etichetta di ciascuna opzione.
      </td>
    </tr>
    <tr>
      <td><code>filtrable</code></td>
      <td>
        `@Input() filtrable = false;` <br />
        Abilita il filtraggio all'interno delle opzioni di selezione multipla.
      </td>
    </tr>
    <tr>
      <td><code>liveSearchStyle</code></td>
      <td>
        `@Input() liveSearchStyle: MultipleSelectLiveSearchStyle = 'contains';` <br />
        Determina lo stile di filtraggio per la ricerca: "contiene" o "startsWith". <br />
        Oggetto di tipo <a href="?path=/docs/resources-models-multipleselectlivesearchstyle--docs">MultipleSelectLiveSearchStyle</a>.
      </td>
    </tr>
    <tr>
      <td><code>selectElementToDisplay</code></td>
      <td>
        `@Input() selectElementToDisplay = 5;` <br />
        Il numero massimo di opzioni visualizzate per impostazione predefinita
      </td>
    </tr>
    <tr>
      <td><code>selectAllCheckbox</code></td>
      <td>
        `@Input() selectAllCheckbox = false;` <br />
       Aggiunge un checkbox 'Select All' in cima all'elenco delle opzioni.
      </td>
    </tr>
    <tr>
      <td><code>allCheckboxLabel</code></td>
      <td>
        `@Input() allCheckboxLabel = 'LABEL.SELECT_ALL_CHECKBOX';` <br />
        Testo dell'etichetta per la casella di controllo 'Select All'
      </td>
    </tr>
    <tr>
      <td><code>readOnlyIfListIsEmpty</code></td>
      <td>
        `@Input() readOnlyIfListIsEmpty = false;` <br />
        Disabilita la selezione se l'elenco delle opzioni è vuoto.
      </td>
    </tr>
    <tr>
      <td><code>maxDigits</code></td>
      <td>
        `@Input() maxDigits = 0;` <br />
        Il numero massimo di cifre consentito.
      </td>
    </tr>
    <tr>
      <td><code>options</code></td>
      <td>
        `@Input() options: Array<any>;` <br />
        Oggetto di tipo <a href="?path=/docs/resources-models-options--docs">Options</a>. L'oggetto opzioni viene utilizzato in MultiSelect.
      </td>
    </tr>
    <tr>
      <td><code>remote</code></td>
      <td>
        `@Input() remote!: (param: any) => Observable<any[]>;` <br />
        L'oggetto remote viene utilizzato in MultiSelectRemote. La funzione `likeOptions` viene passata come input remoto e utilizzata per fornire dati filtrati ogni volta che sono necessari (ad esempio, durante operazioni di ricerca o filtro).".
        `let likeOptions = (term: string): Observable<any[]> => {
           return of(
               selectDatasource.filter((el) =>
               el.descrizione.toLowerCase().includes(term.toLowerCase())
            ));`
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class MultipleSelectComponent extends BaseInputComponent` <br />
        La classe `MultipleSelectComponent` estende <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent</a>
      </td>
    </tr>
      <tr>
        <td><code>size</code></td>
        <td>
        `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
        La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
        </td>
      </tr>
  </tbody>
</table>
</div>