# FormTabellareConfig

Documentazione dettagliata dell' oggetto custom **FormTabellareConfig**, usato nei componenti di Internet Webkit v17. 
**FormTabellareConfig** è una classe progettata per configurare e gestire una tabella formattata (o tabella dinamica) con vari tipi di input e intestazioni.

## Implementazione
<div class="table-responsive">`import {FormTabellareConfig} from '@inail/internet-webkit/form-tabellare'`</div>
<br />

***Struttura:***
`FormTabellareConfig {
    type: number;
    title: string;
    rowTitles: string[];
    columnsHeader: string[];
    columnsHeaderTitle: string[];
    inputsColumnTitle: string[];
    inputsNamePerColumn: string[];
    inputType: FormTabellareInputTypes;
}
`


***Esempio d'uso:***
<br />
`  formTabellare1Config: FormTabellareConfig = {
    type: 1,
    title: 'Form tabellare 1',
    rowTitles: ['Cybersecurity', 'Sicurezza sul lavoro', 'Privacy'],
    columnsHeaderTitle: ['Ore totali', 'Ore seguite'],
    columnsHeader: [''],
    inputsColumnTitle: ['Ore totali', 'Ore seguite'],
    inputsNamePerColumn: ['oreTotali', 'oreSeguite'],
    inputType: FormTabellareInputTypes.NUMERIC,
  }
`


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>type</code></td>
      <td>
        Indica il tipo di configurazione della tabella.
      </td>
    </tr>
    <tr>
      <td><code>title</code></td>
      <td>
        Specifica il titolo della tabella.
      </td>
    </tr>
    <tr>
      <td><code>rowTitles</code></td>
      <td>
        Contiene un array di stringhe che rappresentano i titoli delle righe della tabella.
      </td>
    </tr>
    <tr>
      <td><code>columnsHeaderTitle</code></td>
      <td>
        Un array per definire descrizioni o titoli estesi per le intestazioni delle colonne.
      </td>
    </tr>
    <tr>
      <td><code>columnsHeader</code></td>
      <td>
        Definisce le intestazioni delle colonne.
      </td>
    </tr>
    <tr>
      <td><code>inputsColumnTitle</code></td>
      <td>
        Definisce i titoli delle colonne relative agli input della tabella.
      </td>
    </tr>
    <tr>
      <td><code>inputsNamePerColumn</code></td>
      <td>
        Specifica i nomi degli input associati a ciascuna colonna.
      </td>
    </tr>
     <tr>
      <td><code>inputType</code></td>
      <td>
        Campo di tipo <code>FormTabellareInputTypes</code> che specifica il tipo di input che sarà utilizzato nelle colonne della tabella.
        <ul>
          <li>
            CHECKBOX: Indica che l'input è una casella di controllo (checkbox).
          </li>
          <li>
            NUMERIC: Indica che l'input accetta solo valori numerici.
          </li>
          <li>
            TEXTBOX: Indica che l'input è una casella di testo per l'inserimento libero.
          </li>
          <li>
            DATE: Indica che l'input è un selettore di date.
          </li>
        </ul>
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-form-tabellare--form-tabellare-story">Form Tabellare</a>
<br/>
