## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente Badge Default Prevenzione sono:

* **Titolo**: il testo principale visualizzato nel badge
* **Descrizione**: il testo aggiuntivo che fornisce contesto al titolo
* **Colori**: il componente supporta la personalizzazione dei colori tramite proprietà CSS

Gli aspetti tecnici rilevanti del componente sono:

* Il componente utilizza HTML e CSS per la sua implementazione
* È possibile personalizzare la visualizzazione del componente tramite proprietà CSS

Le caratteristiche di accessibilità del componente sono:

* Il componente supporta la lettura da parte di screen reader
* È possibile aggiungere attributi ARIA per migliorare l'accessibilità

## VARIANTI
Il componente Badge Default Prevenzione ha le seguenti varianti:

* **Prevenzione: Moduli e modelli specifici di sezione**: questa variante visualizza un badge con il titolo "Prevenzione" e una descrizione aggiuntiva
* **Moduli e documenti utili**: questa variante visualizza un badge con il titolo "Moduli e documenti utili" e una descrizione aggiuntiva

Casi d'uso specifici per ogni variante:

* La variante "Prevenzione: Moduli e modelli specifici di sezione" può essere utilizzata per fornire informazioni sulla prevenzione dei rischi lavorativi
* La variante "Moduli e documenti utili" può essere utilizzata per fornire informazioni sui moduli e documenti disponibili per l'utente

## BEST PRACTICES
Le raccomandazioni d'uso del componente Badge Default Prevenzione sono:

* Utilizzare il componente per fornire informazioni aggiuntive e contestuali
* Personalizzare la visualizzazione del componente tramite proprietà CSS
* Assicurarsi che il componente sia accessibile per gli utenti con disabilità

Le linee guida implementative sono:

* Utilizzare HTML e CSS per implementare il componente
* Seguire le best practice per l'accessibilità

Le pratiche da evitare sono:

* Non utilizzare il componente come unico mezzo di comunicazione
* Non trascurare la personalizzazione della visualizzazione del componente

## COMPONENTI CORRELATI
Il componente Badge Default Prevenzione può essere utilizzato in combinazione con altri componenti UI, come ad esempio:

* **Card**: il componente Card può essere utilizzato per fornire ulteriori informazioni sull'argomento trattato dal badge
* **Button**: il componente Button può essere utilizzato per fornire un'azione aggiuntiva per l'utente

Relazioni con altri elementi:

* Il componente Badge Default Prevenzione può essere utilizzato come elemento di una lista o di un gruppo di informazioni
* Il componente può essere personalizzato tramite proprietà CSS per adattarsi allo stile dell'applicazione

## OVERVIEW
<div class="table-responsive">`import { BadgeComponent } from '@inail/internet-webkit/elements';`</div>

Componente che si usa per creare elementi di tipo badge che visualizzano messaggi custom a seconda della situazione.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>mainAction</code></td>
      <td>
        `@Input() mainAction!: ActionItem;` <br />
        Oggetto di tipo <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a> che crea il pulsante principale del badge.
      </td>
    </tr>
    <tr>
      <td><code>actions</code></td>
      <td>
          `@Input() actions: ActionItem[] = [];` <br />
          Array di <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a> che crea i pulsanti secondari del badge, che si trovano dentro il pannello espandibile.
      </td>
    </tr>
    <tr>
      <td><code>colorButton</code></td>
      <td>
          `@Input() colorButton = 'secondary';` <br />
          Specifica il colore del pulsante primario in base alle classi Bootstrap.
      </td>
    </tr>
    <tr>
      <td><code>titleHeading</code></td>
      <td>
          `@Input() titleHeading = '';` <br />
          Imposta l'intestazione principale o il titolo per il componente che si mostra nel pannello espandibile.
      </td>
    </tr>
    <tr>
      <td><code>description</code></td>
      <td>
          `@Input() description = '';` <br />
          Questa proprietà consente di impostare un testo descrittivo, fornendo informazioni aggiuntive o dettagli relativi al componente.
      </td>
    </tr>
    <tr>
      <td><code>titleBadge</code></td>
      <td>
          `@Input() titleBadge = '';` <br />
          Visualizza un badge o un'etichetta per il titolo, fornendo contesto o stato aggiuntivo.
      </td>
    </tr>
    <tr>
      <td><code>id</code></td>
      <td>
          `@Input() id = '';` <br />
          Assegna una stringa ID al componente.
      </td>
    </tr>
    <tr>
      <td><code>isFullHeight</code></td>
      <td>
          `@Input() isFullHeight = false;` <br />
          Parametro booleano che imposta il componente a piena altezza.
      </td>
    </tr>
    <tr>
      <td><code>isLight</code></td>
      <td>
          `@Input() isLight = false;` <br />
          Parametro booleano che abilita uno stile chiaro per il componente.
      </td>
    </tr>
  </tbody>
</table>
</div>