# BootstrapSize

Documentazione dettagliata della classe custom  **BootstrapSize**, usata nei componenti di Intranet Webkit v17. 
**BootstrapSize** viene utilizzata per impostare le dimensioni degli elementi del DOM, usando i breakpoint di Bootstrap nell'ordine definito dalla classe. L'ordine di breakpoints e xs, sm, lg, md.

## Implementazione
<div class="table-responsive">`import {BootstrapSize} from '@inail/intranet-webkit/utils';`</div>
<br />

***Struttura:***
`	/** pay attention to the order. for retrocompatible motivation md is the last */
constructor(xs: number, sm: number, lg: number, md?: number) {
		this._xs = xs;
		this._sm = sm;
		this._lg = lg;
		this._md = md;
}`

***Esempio d'uso:***
<br />
<div class="table-responsive">`bootstrapSize = new BootstrapSize(12, 12, 12, 12)`</div>

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>xs</code> <br /> <code>sm</code> <br /> <code>lg</code> <br /> <code>md</code></td>
      <td>
        Campi di tipo number che impostano le classi `col-` di Bootstrap tramite le funzioni <code>toBootstrapClass()</code> e <code>toComplementaryBootstrapClass()</code>. 
        <br />
        <code> <pre> 	public toBootstrapClass(): string {
	      	  let classString = '';
	      	  if (this.xs) {
	      	  	classString += ' col-' + this.xs;
	      	  }
	      	  if (this.sm) {
	      	  	classString += ' col-sm-' + this.sm;
	      	  }
	      	  if (this.md) {
	      	  	classString += ' col-md-' + this.md;
	      	  }
	      	  if (this.lg) {
	      	  	classString += ' col-lg-' + this.lg;
	      	  }
	      	  return classString;
	    } </pre> </code>
        <code> <pre> 		public toComplementaryBootstrapClass(): string {
	        	let classString = '';
	        	if (this.xs) {
	        		classString += ' col-' + (12 - this.xs);
	        	}
	        	if (this.sm) {
	        		classString += ' col-sm-' + (12 - this.sm);
	        	}
	        	if (this.md) {
	        		classString += ' col-md-' + (12 - this.md);
	        	}
	        	if (this.lg) {
	        		classString += ' col-lg-' + (12 - this.lg);
	        	}
	        	return classString;
	    } </pre> </code>
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-elements-alert--alert">Alert</a>
<br />
<a href="?path=/story/components-elements-input-detail--input-detail">Input Detail</a>
<br />
<a href="?path=/story/components-form-form-controls-checkbox--checkbox">Form Controls</a>
<br />
<a href="?path=/story/components-elements-progress-bar--progress-bar">Progress Bar</a>
<br />
<a href="?path=/story/components-carousel--basic-carousel">Expandable Tabs</a>
<br />
<a href="?path=/story/components-carousel--basic-carousel">Upload File</a>