# Step

Documentazione dettagliata della custom class **Step**, usata nei componenti di Internet Webkit v17. 
**Step** viene utilizzato per creare l'oggetto `Step` di un componente <a href="?path=/story/components-wizard--wizard">Wizard</a>, che serve per connettere un template alla logica di un passo di un <a href="?path=/story/components-wizard--wizard">Wizard</a> a fasi multiple.

## Implementazione
<div class="table-responsive">`import { Step } from '@inail/internet-webkit';`</div>
<br />

***Struttura:***
`constructor(id: any,
  title: string,
  hasError: boolean,
  disabled: boolean,
  visited?: boolean | undefined,
  visible?: boolean,
  hasWarning?: boolean | undefined)`

***Esempio d'uso:***
<br />
`step = new Step('step3', 'Warning/Error Step', true, false, false, true, true)`

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>id</code></td>
      <td>
        Campo di tipo any che assegna un id a uno step.
      </td>
    </tr>
    <tr>
      <td><code>title</code></td>
      <td>
        Campo di tipo string che imposta il titolo che viene visualizzatto nel <a href="?path=/story/components-wizard--wizard">Wizard</a>.
      </td>
    </tr>
    <tr>
      <td><code>hasError</code></td>
      <td>
        Campo di tipo booleano che indica se lo step presenta un errore, influenzando anche la sua visualizzazione. La logica può essere gestita in base alle necessità dell'uso di uno step del <a href="?path=/story/components-wizard--wizard">Wizard</a>.
        <br />
        ***Esempio:*** Uno step del <a href="?path=/story/components-wizard--wizard">Wizard</a> contiene un form con dei campi obbligatori non completati dall'utente. Se l'utente passa a un altro step, questo mostrerà un'icona di errore e diventerà rosso per segnalare l'errore all'utente.
      </td>
    </tr>
    <tr>
      <td><code>disabled</code></td>
      <td>
        Campo di tipo booleano che si usa per disabilitare uno step del <a href="?path=/story/components-wizard--wizard">Wizard</a>.
      </td>
    </tr>
    <tr>
      <td><code>visited</code></td>
      <td>
        Campo di tipo booleano non obbligatorio che si usa per segnalare che uno step del <a href="?path=/story/components-wizard--wizard">Wizard</a> è stato gia visitato. Se non ci sono errori in questo step (segnalati tramite `hasError`) lo step mostrerà un' icona check e diventerà verde.
      </td>
    </tr>
    <tr>
      <td><code>visible</code></td>
      <td>
        Campo booleano non obbligatorio che si usa per mostrare/nascondere uno step.
      </td>
    </tr>
    <tr>
      <td><code>hasWarning</code></td>
      <td>
        Campo di tipo booleano non obbligatorio che viene utilizzato per mostrare un'icona di warning al posto del numero di step normalmente visualizzato.
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-wizard--wizard">Wizard</a>
