# Tag

Documentazione dettagliata del custom model **Tag**, usato nei componenti di Intranet Webkit v17. 
**Tag** viene utilizzato per costruire gli oggetti che poi si visualizzano come componenti <a href="?path=/story/components-elements-tags--tags">Tag</a>.

## Implementazione
<div class="table-responsive">`import { Tag } from '@inail/intranet-webkit/elements';`</div>
<br />

***Struttura:***
`	constructor(
		public value: string,
		public type: TagTypes = TagTypes.DEFAULT,
		public label?: string) {}`

***Esempio d'uso:***
<br />
<div class="table-responsive">`tag = new Tag('TAG_1', TagTypes.INFO)`</div>

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>value</code></td>
      <td>
        Campo di tipo string che assegna l'etichetta che si visualizza nel tag.
      </td>
    </tr>
    <tr>
      <td><code>type</code></td>
      <td>
        Campo di tipo <code>TagTypes</code> che imposta il tipo di tag. Questo campo ha anche un impatto visuale.
        I valori dell' enum sono i seguenti:
        <ul>
          <li>
            DEFAULT
          </li>
          <li>
            PRIMARY
          </li>
          <li>
            SUCCESS
          </li>
          <li>
            INFO
          </li>
          <li>
            WARNING
          </li>
          <li>
            DANGER
          </li>
        </ul>
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-elements-tags--tags">Tags</a>
<br />
<a href="?path=/story/components-elements-sticky--sticky">Sticky</a>