## CARATTERISTICHE PRINCIPALI

Le funzionalità chiave del componente "Modal" includono:

* Personalizzazione del titolo e del contenuto della finestra modale
* Opzione di mostrare o nascondere il pulsante di chiusura
* Gestione dell'aspetto "one last focus" per garantire l'accessibilità

Gli aspetti tecnici rilevanti includono:

* L'utilizzo di HTML, CSS e JavaScript per la creazione e gestione della finestra modale
* La possibilità di utilizzare attributi e proprietà per personalizzare il comportamento del componente

Le caratteristiche di accessibilità includono:

* La gestione dell'aspetto "one last focus" per garantire che gli utenti con disabilità possano interagire correttamente con la finestra modale

## VARIANTI

Le varianti disponibili per il componente "Modal" includono:

* **Basic Modal**: una versione di base del componente con un titolo e un contenuto personalizzabile
* Altre varianti non sono disponibili (N.D.)

Per ogni variante, i casi d'uso specifici includono:

* Utilizzare la finestra modale per visualizzare informazioni aggiuntive relative a un elemento della pagina
* Utilizzare la finestra modale per mostrare un messaggio di conferma o di errore

Una breve descrizione per ogni variante è la seguente:

* **Basic Modal**: una versione di base del componente che consente di personalizzare il titolo e il contenuto della finestra modale

## BEST PRACTICES

Le raccomandazioni d'uso per il componente "Modal" includono:

* Utilizzare la finestra modale solo quando è necessario, per evitare di disturbare l'utente
* Assicurarsi che la finestra modale sia accessibile e utilizzabile da utenti con disabilità

Le linee guida implementative includono:

* Utilizzare gli attributi e le proprietà corretti per personalizzare il comportamento del componente
* Assicurarsi di testare la finestra modale in diversi browser e dispositivi per garantire la compatibilità

Le pratiche da evitare includono:

* Utilizzare la finestra modale come unica forma di interazione con l'utente, senza offrire alternative
* Non fornire una chiara indicazione del contenuto della finestra modale, rendendola difficile da comprendere per gli utenti

## COMPONENTI CORRELATI

I componenti associati al componente "Modal" includono:

* **Button**: un componente che può essere utilizzato per attivare la finestra modale
* Altri componenti non sono disponibili (N.D.)

Le relazioni con altri elementi includono:

* La possibilità di utilizzare il componente "Modal" all'interno di altri componenti, come ad esempio un **Panel** o un **Accordion**
* La necessità di considerare la posizione e la dimensione della finestra modale rispetto agli altri elementi della pagina

## OVERVIEW
<div class="table-responsive">`import { ModalComponent } from '@inail/intranet-webkit/modals';`</div>

Il ModalComponent è un componente progettato per creare finestre modali personalizzabili e interattive all'interno di un'applicazione. Offre un'ampia gamma di opzioni per configurare titolo, contenuto, dimensione, azioni e comportamento, rendendolo ideale per notifiche, conferme e altri tipi di interazione con l'utente.

Il componente è altamente configurabile e supporta proprietà, eventi e opzioni per gestire scenari complessi, migliorando l'esperienza dell'utente e l'accessibilità.


## API
<div class="table-responsive">
  <table class="table table-documentation">
    <thead>
      <tr>
        <th style="width: 20%"><strong>Campo</strong></th>
        <th style="width: 80%"><strong>Descrizione</strong></th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><code>title</code></td>
        <td> <code>@Input() title!: string;</code><br /> Titolo della finestra modale. Visualizzato nella barra superiore del componente. </td>
      </tr>
      <tr>
        <td><code>id</code></td>
        <td> <code>@Input() id = '';</code><br /> Identificativo univoco per la finestra modale. Può essere utilizzato per riferirsi al componente in modo specifico. </td>
      </tr>
      <tr>
        <td><code>headerAction</code></td>
        <td> <code>@Input() headerAction!: ActionItem[];</code><br /> Azioni configurabili da mostrare nell'intestazione della finestra modale. Accetta un array di elementi di tipo <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>. </td>
      </tr>
      <tr>
        <td><code>size</code></td>
        <td> <code>@Input() size: ModalSizeType = 'md';</code><br /> Dimensione della finestra modale. Valori supportati: <code>'sm'</code>, <code>'md'</code>, <code>'lg'</code>.<br /> Valore predefinito: <code>'md'</code>. </td>
      </tr>
      <tr>
        <td><code>buttons</code></td>
        <td> <code>@Input() buttons: any[]=buttons: any[] = [</code><br />
		<code>new ModalActionItem('BUTTON.CLOSE', () => {</code><br />
		<code>this.close();</code><br />
		<code>}),</code><br />
	<code>];</code><br /> Pulsanti configurabili visualizzati nel footer della finestra modale. Può includere azioni personalizzate, come chiudere la finestra o eseguire una funzione.Accetta un array di elementi di tipo <a href="?path=/docs/resources-models-modalactionitem--docs">ModalActionItem</a>. </td>
      </tr>
      <tr>
        <td><code>oneLastFocus</code></td>
        <td> <code>@Input() oneLastFocus!: boolean;</code><br /> Indica se un elemento specifico dovrebbe ricevere il focus dopo la chiusura della finestra modale. </td>
      </tr>
    </tbody>
  </table>
</div>

<br />
<br />

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Event</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
       <tr>
        <td><code>onClose</code></td>
        <td> <code>@Output() onClose: EventEmitter&lt;any&gt; = new EventEmitter&lt;any&gt;();</code><br /> Evento emesso quando la finestra modale viene chiusa. </td>
      </tr>
 </tbody>
 </table>
 </div>