# ModalActionItem

Documentazione dettagliata dell' oggetto custom **ModalActionItem**, usato nei componenti di Internet Webkit v17.
**ModalActionItem** estende la classe **ActionItem** aggiungendo la possibilità di definire una posizione specifica tramite l'attributo position.

## Implementazione
<div class="table-responsive">`import { ModalActionItem } from '@inail/internet-webkit/modals';`</div>
<br />

***Struttura:***
`constructor(
  name: string,
  action: (action: ActionItem, item: any, onComplete?: Function) => any,
  icon?: string | string[] | undefined,
  type?: ActionItemType = 'NORMAL',
  auth?: string | Array<string>,
  disabled?: boolean,
  extra?: ACTION_ITEM_EXTRA_OPTIONS = {},
  position?: VerticalAlign = VerticalAlign.RIGHT
)`

***Esempio d'uso:***
` modalAction = new ModalActionItem('BUTTON.CLOSE', () => {
			this.close();
		}),;`

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>name</code></td>
      <td> Campo di  tipo string che definisce il nome della azione. </td>
    </tr>
    <tr>
      <td><code>action</code></td>
      <td> Campo che assegna una funzione al <code>ModalActionItem</code>. </td>
    </tr>
    <tr>
      <td><code>icon</code></td>
      <td> Campo non obbligatorio. Può essere una stringa o un array di stringhe. Assegna un'icona all' azione. </td>
    </tr>
    <tr>
      <td><code>type</code></td>
      <td> Campo di tipo <code>ActionItemType</code> che definisce il tipo di azione. Il valore predefinito è <code>'NORMAL'</code>, tra i possibili valori: <ul>
          <li> LINK </li>
          <li> NORMAL </li>
          <li> SECONDARY </li>
          <li> ICON </li>
        </ul> <code>type ActionItemType = 'LINK' | 'NORMAL' | 'SECONDARY' | 'ICON'</code> </td>
    </tr>
    <tr>
      <td><code>auth</code></td>
      <td> Campo non obbligatorio. Può essere una stringa o un array di stringhe. </td>
    </tr>
    <tr>
      <td><code>disabled</code></td>
      <td> Campo non obbligatorio. Booleano che disabilita l'azione. </td>
    </tr>
    <tr>
      <td><code>extra</code></td>
      <td> Campo di tipo <code>ACTION_ITEM_EXTRA_OPTIONS</code> che aggiunge attributi extra al oggetto <code>ModalActionItem</code>. <code>interface ACTION_ITEM_EXTRA_OPTIONS { popoverTemplate?: any; popoverTitle?: string; }</code> </td>
    </tr>
    <tr>
      <td><code>position</code></td>
      <td> Campo non obbligatorio. Specifica l'allineamento verticale dell'azione. I valori validi sono definiti nell'enumerazione <code>VerticalAlign</code>: <ul>
          <li> TOP </li>
          <li> MIDDLE </li>
          <li> BOTTOM </li>
          <li> LEFT </li>
          <li> RIGHT </li>
        </ul> <code>enum VerticalAlign { TOP = 'top', MIDDLE = 'middle', BOTTOM = 'bottom', LEFT = 'left', RIGHT = 'right' }</code> </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br/>
<a href="?path=/story/components-modal-basic--basic-modal">Modal</a>
<br/>
<a href="?path=/story/components-modal-form--modal-with-form">Form Modal</a>

