$(document).ready(function () {
  $("input[data-input-type='multiselect']").each(function () {
    const $input = $(this);
    const $dropdown = $input.siblings(".inail-multiselect-dropdown-menu");
    const $container = $input.closest(".dropdown");

    let currentIndex = -1;
    let isOpening = false;

    function getCheckboxes() {
      return $dropdown.find(".option-checkbox");
    }

    function updateInputValue() {
      const values = getCheckboxes()
        .filter(":checked")
        .map(function () {
          return $(this).val();
        })
        .get();
      $input.val(values.join(", ")).trigger("change");
    }

    function moveSelection(delta) {
      const $checkboxes = getCheckboxes();
      currentIndex =
        (currentIndex + delta + $checkboxes.length) % $checkboxes.length;
      $checkboxes.eq(currentIndex).focus();
    }

    function toggleSelection() {
      const $checkbox = getCheckboxes().eq(currentIndex);
      $checkbox.prop("checked", !$checkbox.prop("checked")).trigger("change");
    }

    function openDropdown() {
      $dropdown.show();
      currentIndex = 0;
      const $checkboxes = getCheckboxes();
      $checkboxes.eq(currentIndex).focus();
      isOpening = true;
      setTimeout(() => (isOpening = false), 100);
    }

    function closeDropdown() {
      $dropdown.hide();
    }

    $input.on("click keydown", function (e) {
      if (e.type === "click" || e.key === "Enter") {
        e.preventDefault();
        $dropdown.is(":visible") ? closeDropdown() : openDropdown();
      }
    });

    $(document).on("keydown", function (e) {
      if (
        !$dropdown.is(":visible") ||
        !$container.has(document.activeElement).length
      )
        return;

      const $checkboxes = getCheckboxes();

   
      const focusedIndex = $checkboxes.index(document.activeElement);
      if (focusedIndex !== -1) {
        currentIndex = focusedIndex;
      }

      switch (e.key) {
        case "ArrowDown":
          e.preventDefault();
          moveSelection(1);
          break;
        case "ArrowUp":
          e.preventDefault();
          moveSelection(-1);
          break;
        case "Enter":
        case " ":
          if (!isOpening) {
            e.preventDefault();
            toggleSelection();
          }
          break;
        case "Escape":
          closeDropdown();
          break;
        case "Tab":
          const lastIndex = $checkboxes.length - 1;
          if (e.shiftKey) {
            if (currentIndex > 0) {
              e.preventDefault();
              moveSelection(-1);
            } else {
              closeDropdown();
            }
          } else {
            if (currentIndex < lastIndex) {
              e.preventDefault();
              moveSelection(1);
            } else {
              closeDropdown();
            }
          }
          break;
      }
    });

    $dropdown.on("change", ".option-checkbox", updateInputValue);

    $(document).on("click", function (e) {
      if (!$container.is(e.target) && $container.has(e.target).length === 0) {
        closeDropdown();
      }
    });
  });
});