## CARATTERISTICHE PRINCIPALI
- **Funzionalità chiave**: il componente Search Filter offre funzionalità di ricerca avanzata, tra cui la possibilità di eseguire ricerche testuali e la selezione di filtri avanzati.
- **Aspetti tecnici rilevanti**: il componente è stato progettato per essere utilizzato con framework come Angular e React, ed è compatibile con i principali dispositivi e browser moderni.
- **Caratteristiche di accessibilità**: il componente Search Filter è stato progettato per essere accessibile agli utenti con disabilità, in conformità con le linee guida WCAG 2.1.

## VARIANTI
- **Variante dimostrativa per il test del componente Search Filter INAIL**: questa variante del componente Search Filter è stata progettata per testare la funzionalità di ricerca avanzata all'interno di un'applicazione o di un sito web.
- **Search Form Sample Search Filter**: questa variante del componente Search Filter offre un esempio di come utilizzare il componente per creare un modulo di ricerca personalizzato.
- **Nome, Cognome, Email, Opzioni Advanced Filter Search Azzera**: questa variante del componente Search Filter offre un esempio di come utilizzare il componente per creare un modulo di ricerca con filtri avanzati.

## BEST PRACTICES
- **Raccomandazioni d'uso**: è consigliabile utilizzare il componente Search Filter in combinazione con altri componenti di interfaccia utente per creare un'esperienza di ricerca completa e personalizzata.
- **Linee guida implementative**: quando si utilizza il componente Search Filter, è importante seguire le linee guida di progettazione e sviluppo dell'applicazione o del sito web per garantire la coerenza e l'integrazione con gli altri elementi dell'interfaccia utente.
- **Pratiche da evitare**: non utilizzare il componente Search Filter come unico elemento dell'interfaccia utente, poiché ciò potrebbe limitare la funzionalità di ricerca e rendere l'applicazione o il sito web meno accessibile.

## COMPONENTI CORRELATI
- **Componenti associati**: il componente Search Filter può essere utilizzato in combinazione con altri componenti di interfaccia utente, come ad esempio la tabella dei risultati, per creare un'esperienza di ricerca completa e personalizzata.
- **Relazioni con altri elementi**: il componente Search Filter interagisce con altri elementi dell'applicazione o del sito web, come ad esempio la barra di navigazione e i menu contestuali, per fornire una funzionalità di ricerca avanzata e accessibile.
  

## OVERVIEW
<div class="table-responsive">`import { SearchFilterComponent } from '@inail/intranet-webkit/search-filter';`</div>

Il componente SearchFilterComponent fornisce un'interfaccia per applicare filtri di ricerca. Consente di configurare criteri di filtro avanzati e visualizzare i risultati in base ai parametri specificati. Include campi per il nome, cognome ed email, con la possibilità di gestire opzioni di filtro avanzate e una legenda per i campi obbligatori.

## API

<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
      <tr>
         <th style="width: 20%"><strong>Campo</strong></th>
         <th style="width: 80%"><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>filterTitle</code></td>
         <td>
            `@Input() filterTitle = 'LABEL.SEARCH_FILTER_TITLE';` <br />
            Il titolo visualizzato per il componente filtro, impostatu su 'LABEL.SEARCH_FILTER_TITLE'.
         </td>
      </tr>
      <tr>
         <td><code>filterButtonLabel</code></td>
         <td>
            `@Input() filterButtonLabel = 'BUTTON.SEARCH';` <br />
           L'etichetta per il pulsante filtro, impostato su 'BUTTON.SEARCH'.
         </td>
      </tr>
	  <tr>
         <td><code>filters</code></td>
         <td>
            `@Input() filters: FilterText[] = [];` <br />
           Un array di criteri di filtro <a href = "?path=/docs/resources-models-filtertext--docs">FilterText</a>.
         </td>
      </tr>
	  <tr>
         <td><code>showAdvancedFilter</code></td>
         <td>
            `@Input() showAdvancedFilter!: boolean;` <br />
          Flag per mostrare o nascondere le opzioni di filtro avanzate
         </td>
      </tr>
	  <tr>
         <td><code>formTitle</code></td>
         <td>
            `@Input() formTitle!: string;` <br />
           Il titolo del modulo.
         </td>
    </tr>
    <tr>
       <td><code>asteriskRequiredLegend</code></td>
       <td>
           `@Input() asteriskRequiredLegend!: boolean;` <br />
           Flag per mostrare o nascondere la legenda dell'asterisco obbligatorio.
        </td>
    </tr>
    <tr>
       <td><code>sizeActions</code></td>
       <td>
           `@Input() sizeActions: BootstrapSize = new BootstrapSize(12, 12, 12, 12);` <br />
           Configurazione della dimensione Bootstrap per i pulsanti Action. <br />
           Tipo di oggetto <a href = "?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize</a>.
        </td>
    </tr>
   </tbody>
</table>
</div>

<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
      <tr>
         <th style="width: 20%"><strong>Event</strong></th>
         <th style="width: 80%"><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>onSearch</code></td>
         <td>
            `@Output() onSearch = new EventEmitter<boolean>();` <br />
             onSearch viene emesso per avviare la ricerca con i criteri selezionati.
         </td>
      </tr>
      <tr>
         <td><code>onReset</code></td>
         <td>
            `@Output() onReset = new EventEmitter<boolean>();` <br />
            onReset viene emesso per ripristinare i filtri allo stato iniziale.
         </td>
      </tr>
   </tbody>
</table>
</div>