## CARATTERISTICHE PRINCIPALI
Le caratteristiche principali del componente Interval Number sono:

* Funzionalità chiave: inserimento di un intervallo numerico
* Aspetti tecnici rilevanti: il componente utilizza una struttura di dati per memorizzare l'intervallo numerico
* Caratteristiche di accessibilità: il componente è progettato per essere accessibile aiutando gli utenti con disabilità motorie o visive

## VARIANTI
Le varianti disponibili del componente Interval Number sono:

* **IntervalFrom**: variante che consente di impostare solo il valore minimo dell'intervallo
	+ Caso d'uso: quando si desidera impostare un limite inferiore per l'intervallo
	+ Breve descrizione: "Imposta il valore minimo dell'intervallo"
* **IntervalTo**: variante che consente di impostare solo il valore massimo dell'intervallo
	+ Caso d'uso: quando si desidera impostare un limite superiore per l'intervallo
	+ Breve descrizione: "Imposta il valore massimo dell'intervallo"
* **IntervalFromTo**: variante che consente di impostare sia il valore minimo che il valore massimo dell'intervallo
	+ Caso d'uso: quando si desidera impostare un intervallo completo
	+ Breve descrizione: "Imposta l'intervallo numerico"

## BEST PRACTICES
Le raccomandazioni per l'uso del componente Interval Number sono:

* Utilizzare il componente Interval Number quando si desidera inserire un intervallo numerico in modo facile e intuitivo
* Impostare i valori minimo e massimo dell'intervallo per garantire la validità dei dati
* Utilizzare le varianti del componente per adattarsi alle esigenze specifiche dell'applicazione

## COMPONENTI CORRELATI
Il componente Interval Number è associato ai seguenti componenti:

* **Number**: componente che consente di inserire un singolo valore numerico
* **Range**: componente che consente di inserire un intervallo numerico con una scrollbar

## OVERVIEW
<div class="table-responsive">`import { InputNumberIntervalComponent } from '@inail/intranet-webkit/form-controls';`</div>

Il componente Input Number Interval è progettato per gestire l'inserimento di un intervallo numerico tramite due campi di input separati. È particolarmente utile per applicazioni in cui è necessario specificare limiti numerici, come fasce di prezzo, età o altre misurazioni numeriche.

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>fromLabel</code></td>
      <td>
        `@Input() fromLabel = 'INPUT.FROM';` <br />
        Etichetta per l'inizio dell'intervallo.
      </td>
    </tr>
     <tr>
      <td><code>toLabel</code></td>
      <td>
        `@Input() toLabel = 'INPUT.TO';` <br />
        Etichetta per la fine dell'intervallo.
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class InputNumberIntervalComponent extends BaseInputComponent` <br />
        La classe `InputNumberIntervalComponent` estende <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent.</a>
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
      `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
      La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
      </td>
    </tr>
  </tbody>
</table>
</div>