# ExpandableTab

La classe **ExpandableTab** rappresenta un modello per definire una scheda espandibile con proprietà personalizzate. È strutturata tramite un costruttore che accetta i seguenti parametri: 
**ExpandableTab** viene usato per costruire azioni () custom tramite la struttura definita dal costruttore.

## Implementazione
<div class="table-responsive">`import { ExpandableTab } from '@inail/intranet-webkit/tabs';`</div>
<br />

***Struttura:***
`constructor(
      id: number, 
      title: string, 
      templateNo: any, 
      action?: ActionItem | undefined, 
      hasError?: boolean | undefined, 
      disable?: boolean | undefined
      )`

***Esempio d'uso:***
` tabs: ExpandableTab[] = [
  new ExpandableTab(1, 'Tab 1', this.template1, undefined,false),
  new ExpandableTab(2, 'Tab 2', this.template2, undefined,false),
  new ExpandableTab(3, 'Tab 3', this.template3,{ icon:'settings' } as ActionItem,false),
    ]`

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>id</code></td>
      <td>
        Un numero obbligatorio che identifica univocamente la scheda.
      </td>
    </tr>
    <tr>
      <td><code>title</code></td>
      <td>
        Una stringa obbligatoria che rappresenta il titolo della scheda.
      </td>
    </tr>
    <tr>
      <td><code>templateNo</code></td>
      <td>
        Un parametro obbligatorio di tipo generico (any) che indica il numero del modello o un valore associato al template della scheda.
      </td>
    </tr>
    <tr>
      <td><code>action</code></td>
      <td>
       Un parametro opzionale che rappresenta un'azione associata alla scheda. Può essere un oggetto di tipo <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a> o non definito.
      </td>
    </tr>
    <tr>
      <td><code>hasError</code></td>
      <td>
        Campo non obbligatorio. Può essere una stringa o un array di string.
      </td>
    </tr>
    <tr>
      <td><code>disable</code></td>
      <td>
        Un valore booleano opzionale che specifica se la scheda è disabilitata (true se disabilitata, altrimenti false o undefined).
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="??path=/story/components-tabs-expandable-tabs--expandable-tabs">Expandable Tabs</a>
