## CARATTERISTICHE PRINCIPALI
Il componente Upload File presenta le seguenti caratteristiche principali:

* Funzionalità chiave:
 + Caricare file dal sistema locale dell'utente
 + Visualizzare il nome del file caricato
 + Fornire informazioni sulla dimensione massima del file e sulle estensioni permesse
* Aspetti tecnici rilevanti:
 + Il componente utilizza la proprietà "accept" per specificare le estensioni dei file permessi
 + Il componente utilizza la proprietà "max-size" per specificare la dimensione massima del file
* Caratteristiche di accessibilità:
 + Il componente è progettato per essere accessibile agli utenti con disabilità

## VARIANTI
Il componente Upload File presenta le seguenti varianti:

* Variante 1: Caricare un file
 + Descrizione: il componente consente all'utente di caricare un file dal sistema locale
 + Caso d'uso: l'utente vuole caricare un documento per condividerlo con altri utenti
 + Breve descrizione: "Carica un file dal tuo sistema locale"
* Variante 2: Visualizzare il nome del file caricato
 + Descrizione: il componente visualizza il nome del file caricato dall'utente
 + Caso d'uso: l'utente vuole verificare che il file sia stato caricato correttamente
 + Breve descrizione: "Nome del file caricato"
* Variante 3: Fornire informazioni sulla dimensione massima del file e sulle estensioni permesse
 + Descrizione: il componente fornisce informazioni sulla dimensione massima del file e sulle estensioni permesse
 + Caso d'uso: l'utente vuole sapere quali tipi di file possono essere caricati
 + Breve descrizione: "Informazioni sulla dimensione massima del file e sulle estensioni permesse"

## BEST PRACTICES
Per utilizzare il componente Upload File in modo efficace, si consiglia di:

* Utilizzare un testo chiaro e conciso per la descrizione del componente
* Fornire informazioni sulla dimensione massima del file e sulle estensioni permesse
* Utilizzare un design accessibile per il componente

## COMPONENTI CORRELATI
Il componente Upload File è correlato ai seguenti componenti:

* Componente di caricamento dei file
* Componente di gestione dei file
* Componente di condivisione dei file

## OVERVIEW
<div class="table-responsive">`import { UploadFileComponent } from '@inail/intranet-webkit/form-controls';`</div>

Il componente Upload File è progettato per consentire agli utenti di caricare facilmente file all'interno di un'interfaccia utente. È ideale per caricare file, come immagini, documenti o video.


## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
	<tr>
	  <th style="width: 20%"><strong>Campo</strong></th>
	  <th style="width: 80%"><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
	<tr>
	  <td><code>idUpload</code></td>
	  <td>
		`@Input() idUpload = composeUniqueId('upload');` <br />
		Identificatore univoco per il campo di input per il caricamento.
	  </td>
	</tr>
	<tr>
	  <td><code>labelUpload</code></td>
	  <td>
		`@Input() labelUpload!: string;` <br />
		Testo dell'etichetta visualizzato per il campo di input per il caricamento.
	  </td>
	</tr>
	<tr>
	  <td><code>descMaxSize</code></td>
	  <td>
		`@Input() descMaxSize!: string;` <br />
		Testo descrittivo che indica la dimensione massima del file consentita per il caricamento.
	  </td>
	</tr>
	<tr>
	  <td><code>maxSize</code></td>
	  <td>
		`@Input({required: true}) maxSize!: number;` <br />
		Dimensione massima consentita (in byte) per ogni file caricato.	  </td>
	</tr>
	<tr>
	  <td><code>numMaxFile</code></td>
	  <td>
		`@Input() numMaxFile = 1;` <br />
		Numero massimo di file che possono essere caricati contemporaneamente.  </td>
	</tr>
	<tr>
	  <td><code>extensions</code></td>
	  <td>
		`@Input({required: true}) extensions!: string[];` <br />
		Estensioni di file consentite per il caricamento (es. [".jpg", ".png"]).  </td>
	</tr>
	<tr>
	  <td><code>maxNameLength</code></td>
	  <td>
		`@Input() maxNameLength = 250;` <br />
		Lunghezza massima consentita per ogni nome di file.  </td>
	</tr>
	<tr>
	  <td><code>size-label</code></td>
	  <td>
		`@Input() size-label: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
		Bootstrap size dell'input label.  </td>
	</tr>
	<tr>
	  <td><code>size-input</code></td>
	  <td>
		`@Input() size-input: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
		Bootstrap size dell'input.  </td>
	</tr>
	<tr>
	  <td><code>size-messages</code></td>
	  <td>
		`@Input() size-messages: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
		Bootstrap size dei messaggi di input.  </td>
	</tr>
	<tr>
		<td><code>size</code></td>
		<td>
		   `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
			La proprietà `size` di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
		</td>
	</tr>
  </tbody>
</table>
</div>

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
	<tr>
	  <th style="width: 20%"><strong>Event</strong></th>
	  <th style="width: 80%"><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
	<tr>
	  <td><code>addFile</code></td>
	  <td>
		`@Output() addFile = new EventEmitter<File[]>();` <br />
		Event emitter che emette l'evento addFile.
	  </td>
	</tr>
  </tbody>
</table>
</div>